/*  selectwm - X11 window manager selector
 *
 *  Copyright (C) 1999-2004  Luc Dufresne - luc@ordiluc.net
 *                           26, rue des Comices
 *                           59650 Villeneuve d'Ascq
 *                           FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include "define.h"

#include <gtk/gtk.h>

#include "misc.h"
#include "callbacks.h"

void messagebox (const gchar *msg, GtkMessageType  type) {
	GtkWidget *dialog;
	dialog = gtk_message_dialog_new ( NULL , GTK_DIALOG_MODAL, type, GTK_BUTTONS_CLOSE, msg);

	g_signal_connect (G_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), NULL);
	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
	gtk_widget_show (dialog);
}

gint askbox (const gchar *msg) {
	GtkWidget *dialog;
	gint i;
	
	dialog = gtk_message_dialog_new ( NULL , GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, msg);
	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
	i = gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
	return i;
}

void set_defaultwm (GtkListStore *store, GtkTreeIter *iter) {
	GdkColor color = { 0, 0, 0, 0xFFFF };
	gtk_list_store_set (store, iter,
			C_DEFAULT, TRUE,
			C_COLOR, &color, -1); 
}

void remove_defaultwm (GtkTreeModel *model) {
	GdkColor color = { 0, 0, 0, 0};
	GtkTreeIter iter;

	gtk_tree_model_get_iter_first (model, &iter);
	do {
			gtk_list_store_set (GTK_LIST_STORE (model), &iter,
			C_DEFAULT, FALSE,
			C_COLOR, &color, -1);
	} while (gtk_tree_model_iter_next (model, &iter));
}

static void make_edit_config_window (GtkWidget *w, gpointer data) {
	GtkWidget *window, *hbox, *vbox, *vbox2, *win_vbox, *spin, *label, *radio1, *radio2, *radio3, *frame, *btn, *bbox, *notebook;
	GtkObject *adj;
	config *selectwm_config = (config *) data;
	ch_options choptions;
	
	gtk_timeout_remove (selectwm_config->timer);
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_modal (GTK_WINDOW (window), TRUE);
	g_signal_connect (G_OBJECT (window), "destroy",
		  G_CALLBACK (gtk_main_quit),
		  &window);
	gtk_window_set_title (GTK_WINDOW (window), _("Preferences"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
	gtk_window_set_resizable (GTK_WINDOW (window), 0);

	win_vbox = gtk_vbox_new (FALSE , 0);
	gtk_container_add (GTK_CONTAINER (window), win_vbox);
	
	notebook = gtk_notebook_new ();

	gtk_container_add (GTK_CONTAINER (win_vbox), notebook);

	/*  page de configuration  */

	frame = gtk_frame_new (NULL);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);	
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, gtk_label_new (_("Config")));
	
	vbox = gtk_vbox_new (FALSE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);		
	gtk_container_add (GTK_CONTAINER (frame), vbox);
	
	hbox = gtk_hbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	adj = gtk_adjustment_new (selectwm_config->delay, 0.0, 3600.0, 0.1, 1.0, 0.0);
	spin = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1.0, 1);	
	gtk_box_pack_start (GTK_BOX (hbox), spin, FALSE, FALSE, 0);
	
	label = gtk_label_new (_("Timeout in seconds (0 = infinite)"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

	frame = gtk_frame_new (_("\"Go back...\" button"));
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);		
	gtk_container_add (GTK_CONTAINER (frame), vbox2);
	
	label = gtk_label_new (_("State of the \"Go back to selectwm when\nthe WM exits\" button when selectwm starts"));
	gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, FALSE, 0);

	radio1 = gtk_radio_button_new_with_mnemonic (NULL,_("_Checked"));
	g_signal_connect (G_OBJECT (radio1), "clicked", G_CALLBACK (gob1_callback), selectwm_config);
	radio2 = gtk_radio_button_new_with_mnemonic (gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio1)),_("_Not checked"));
	g_signal_connect (G_OBJECT (radio2), "clicked", G_CALLBACK (gob2_callback), selectwm_config);
	radio3 = gtk_radio_button_new_with_mnemonic (gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio2)),_("_Remember last state"));
	g_signal_connect (G_OBJECT (radio3), "clicked", G_CALLBACK (gob3_callback), selectwm_config);

	switch (selectwm_config->goback_btn) {
		case 1:
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio1), TRUE);
			break;
		case 2:
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio2), TRUE);
			break;
		case 3:
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio3), TRUE);
			break;
	}
	
	gtk_box_pack_start (GTK_BOX (vbox2), radio1, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox2), radio2, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox2), radio3, TRUE, TRUE, 0);
	
	/*   page 'about'   */

	frame = gtk_frame_new (NULL);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);	
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, gtk_label_new (_("About")));

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), hbox);

	gtk_box_pack_start (GTK_BOX (hbox),
			gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_DIALOG),
			TRUE, TRUE, 0);
	
	label = gtk_label_new (""PACKAGE" "VERSION"\nhttp://ordiluc.net/selectwm/\n\nCopyright (c) 1999-2004\nLuc Dufresne <luc@ordiluc.net>");
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);

	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (win_vbox), bbox, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (bbox), 10);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_SPREAD );
	btn = gtk_button_new_from_stock (GTK_STOCK_OK);
	choptions.window = window;
	choptions.spin = spin;
	choptions.selectwm_config = selectwm_config;
	g_signal_connect (G_OBJECT (btn), "clicked", G_CALLBACK(change_options), &choptions);
	GTK_WIDGET_SET_FLAGS (btn, GTK_CAN_DEFAULT);
	gtk_container_add (GTK_CONTAINER (bbox), btn);
	gtk_widget_grab_default (btn);
	btn = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	g_signal_connect_swapped (G_OBJECT (btn), "clicked", G_CALLBACK(gtk_widget_destroy), window);
	gtk_container_add (GTK_CONTAINER (bbox), btn);

	GTK_WIDGET_SET_FLAGS (btn, GTK_CAN_DEFAULT);

	gtk_widget_show_all (win_vbox);
	gtk_widget_show (window);
	gtk_main ();
}

void cell_edited (GtkCellRendererText *cell, const gchar *path_string, const gchar *new_text, gpointer data)
{
	GtkTreeModel *model = (GtkTreeModel *) data;
	GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
	GtkTreeIter iter;
	gchar *old_text;

	gint *column;

	column = g_object_get_data (G_OBJECT (cell), "column");
	gtk_tree_model_get_iter (model, &iter, path);
	
	gtk_tree_model_get (model, &iter, column, &old_text, -1);
	g_free (old_text);

	gtk_list_store_set (GTK_LIST_STORE (model), &iter, column, new_text, -1);
	gtk_tree_path_free (path);
}

static void add_columns (config *selectwm_config) {
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	renderer = gtk_cell_renderer_pixbuf_new ();
	column = gtk_tree_view_column_new_with_attributes (NULL, renderer, "pixbuf", C_ICON, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (selectwm_config->treeview), column);
	
	renderer = gtk_cell_renderer_text_new ();
	g_signal_connect (G_OBJECT (renderer), "edited", G_CALLBACK (cell_edited), selectwm_config->model);
	column = gtk_tree_view_column_new_with_attributes (NULL, renderer, "text", C_DESC, "editable", C_EDITABLE, "foreground-gdk", C_COLOR, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gint *) C_DESC);
	gtk_tree_view_append_column (GTK_TREE_VIEW (selectwm_config->treeview), column);
}	

GtkWidget * make_main_window (config *selectwm_config) {
	GtkWidget *scroll, *vbox, *hbox, *confbtn, *quitbtn, *restart;
	
	selectwm_config->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (selectwm_config->window), ""PACKAGE" "VERSION"");
	g_signal_connect (G_OBJECT (selectwm_config->window), "destroy", G_CALLBACK (quit_selectwm), selectwm_config);
	
	gtk_container_set_border_width (GTK_CONTAINER (selectwm_config->window), 2);
	gtk_window_set_position (GTK_WINDOW (selectwm_config->window), GTK_WIN_POS_CENTER);
	
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (selectwm_config->window), vbox);

	scroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scroll), GTK_SHADOW_IN);

	gtk_box_pack_start (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
	gtk_widget_show (scroll);
	gtk_widget_set_size_request (scroll, 150, 150);
	
	selectwm_config->model = GTK_TREE_MODEL (gtk_list_store_new (N_COLUMNS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, GDK_TYPE_COLOR, G_TYPE_BOOLEAN));
	selectwm_config->treeview = gtk_tree_view_new_with_model (selectwm_config->model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (selectwm_config->treeview), TRUE);
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (selectwm_config->treeview), FALSE);
	gtk_tree_view_set_reorderable (GTK_TREE_VIEW (selectwm_config->treeview), TRUE);
	gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (selectwm_config->treeview)), GTK_SELECTION_SINGLE);
	add_columns (selectwm_config);
	g_signal_connect (G_OBJECT (selectwm_config->treeview), "button_press_event", G_CALLBACK (list_click), selectwm_config);
	g_signal_connect (G_OBJECT (selectwm_config->treeview), "key_press_event", G_CALLBACK (list_enter), selectwm_config);
	gtk_container_add (GTK_CONTAINER (scroll), selectwm_config->treeview);
	
	selectwm_config->label = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX (vbox), selectwm_config->label, FALSE, FALSE, 0);

	restart = gtk_check_button_new_with_mnemonic (_("_Go back to selectwm\nwhen the WM exits"));
	gtk_box_pack_start (GTK_BOX (vbox), restart, FALSE, FALSE, 0);

	g_signal_connect (G_OBJECT (restart), "toggled", G_CALLBACK(goback_callback), selectwm_config);
	
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	quitbtn = gtk_button_new_from_stock (GTK_STOCK_QUIT);
	g_signal_connect (G_OBJECT (quitbtn), "clicked", G_CALLBACK (quit_selectwm), selectwm_config);
	gtk_box_pack_start (GTK_BOX (hbox), quitbtn, TRUE, TRUE, 2);
	confbtn = gtk_button_new_from_stock (GTK_STOCK_PREFERENCES);
	g_signal_connect (G_OBJECT (confbtn), "clicked", G_CALLBACK (make_edit_config_window), selectwm_config);
	gtk_box_pack_start (GTK_BOX (hbox), confbtn, TRUE, TRUE, 2);

	gtk_widget_show_all (vbox);

	return restart;
}
