/* Generated by GOB (v1.0.12) on Tue Apr  9 20:56:49 2002
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 12

#include "sand-window.h"


#line 12 "../gob/sand-window.gob"

#include "locate.h"
#include "../pixmaps/icon24.xbm"

static double
mask_get_value (unsigned char *source, int width, int height, int i, int j)
{
  int  jj = j+0.5*ABS(width/2-i);

  if (jj >= height)  return 0;
  return  source[jj*width+i]/255.0;
}

static void
mask_set_value (unsigned char *target, unsigned char *source, double x,
		int width, int height, int i, int j)
{
  int  jj = j+0.5*ABS(width/2-i);

  if (jj >= height)  return;
  target[jj*width+i] = x*source[jj*width+i];
}

#line 38 "sand-window.c"
/* self casting macros */
#define SELF(x) SAND_WINDOW(x)
#define SELF_CONST(x) SAND_WINDOW_CONST(x)
#define IS_SELF(x) SAND_IS_WINDOW(x)
#define TYPE_SELF SAND_TYPE_WINDOW
#define SELF_CLASS(x) SAND_WINDOW_CLASS(x)

#define SELF_GET_CLASS(x) SAND_WINDOW_GET_CLASS(x)

/* self typedefs */
typedef SandWindow Self;
typedef SandWindowClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void ___object_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void ___object_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void sand_window_class_init (SandWindowClass * c) G_GNUC_UNUSED;
static void sand_window_create_shape (SandWindow * self, int image_width, int image_height) G_GNUC_UNUSED;
static void ___2_sand_window_size_request (GtkWidget * widget, GtkRequisition * requisition) G_GNUC_UNUSED;
static void sand_window_drop_handler (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * selection_data, guint info, guint time, gpointer data) G_GNUC_UNUSED;
static void ___4_sand_window_realize (GtkWidget * widget) G_GNUC_UNUSED;
static void sand_window_size_allocate_handler (GtkWidget * widget, GtkAllocation * allocation, gpointer data) G_GNUC_UNUSED;
static void sand_window_init (SandWindow * swindow) G_GNUC_UNUSED;
static void ___7_sand_window_destroy (GtkObject * object) G_GNUC_UNUSED;
static void sand_window_set_decorations (SandWindow * self) G_GNUC_UNUSED;
static void sand_window_init_color (SandWindow * self, guint8 r, guint8 g, guint8 b) G_GNUC_UNUSED;
static void sand_window_set_mask (SandWindow * self, double q) G_GNUC_UNUSED;
static void sand_window_redraw (SandWindow * self) G_GNUC_UNUSED;
static void sand_window_refill (SandWindow * self) G_GNUC_UNUSED;
static void sand_window_init_sand (SandWindow * self) G_GNUC_UNUSED;

enum {
	ARG_0,
	ARG_DECORATIONS
};

/* pointer to the class of our parent */
static GtkWindowClass *parent_class = NULL;

GtkType
sand_window_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"SandWindow",
			sizeof (SandWindow),
			sizeof (SandWindowClass),
			(GtkClassInitFunc) sand_window_class_init,
			(GtkObjectInitFunc) sand_window_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (gtk_window_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define create_shape(args...) sand_window_create_shape(args)
#define self_create_shape(args...) sand_window_create_shape(args)
#define drop_handler(args...) sand_window_drop_handler(args)
#define self_drop_handler(args...) sand_window_drop_handler(args)
#define size_allocate_handler(args...) sand_window_size_allocate_handler(args)
#define self_size_allocate_handler(args...) sand_window_size_allocate_handler(args)
#define new() sand_window_new()
#define self_new() sand_window_new()
#define set_decorations(args...) sand_window_set_decorations(args)
#define self_set_decorations(args...) sand_window_set_decorations(args)
#define get_layer(args...) sand_window_get_layer(args)
#define self_get_layer(args...) sand_window_get_layer(args)
#define set_layer(args...) sand_window_set_layer(args)
#define self_set_layer(args...) sand_window_set_layer(args)
#define init_color(args...) sand_window_init_color(args)
#define self_init_color(args...) sand_window_init_color(args)
#define set_mask(args...) sand_window_set_mask(args)
#define self_set_mask(args...) sand_window_set_mask(args)
#define redraw(args...) sand_window_redraw(args)
#define self_redraw(args...) sand_window_redraw(args)
#define refill(args...) sand_window_refill(args)
#define self_refill(args...) sand_window_refill(args)
#define init_sand(args...) sand_window_init_sand(args)
#define self_init_sand(args...) sand_window_init_sand(args)
#define get_color(args...) sand_window_get_color(args)
#define self_get_color(args...) sand_window_get_color(args)
#define set_color(args...) sand_window_set_color(args)
#define self_set_color(args...) sand_window_set_color(args)
#define flood(args...) sand_window_flood(args)
#define self_flood(args...) sand_window_flood(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static void (* const create_shape) (SandWindow * self, int image_width, int image_height) = sand_window_create_shape;
static void (* const self_create_shape) (SandWindow * self, int image_width, int image_height) = sand_window_create_shape;
static void (* const drop_handler) (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * selection_data, guint info, guint time, gpointer data) = sand_window_drop_handler;
static void (* const self_drop_handler) (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * selection_data, guint info, guint time, gpointer data) = sand_window_drop_handler;
static void (* const size_allocate_handler) (GtkWidget * widget, GtkAllocation * allocation, gpointer data) = sand_window_size_allocate_handler;
static void (* const self_size_allocate_handler) (GtkWidget * widget, GtkAllocation * allocation, gpointer data) = sand_window_size_allocate_handler;
static GtkWidget * (* const new) (void) = sand_window_new;
static GtkWidget * (* const self_new) (void) = sand_window_new;
static void (* const set_decorations) (SandWindow * self) = sand_window_set_decorations;
static void (* const self_set_decorations) (SandWindow * self) = sand_window_set_decorations;
static GnomeWinLayer (* const get_layer) (SandWindow * self) = sand_window_get_layer;
static GnomeWinLayer (* const self_get_layer) (SandWindow * self) = sand_window_get_layer;
static void (* const set_layer) (SandWindow * self, GnomeWinLayer layer) = sand_window_set_layer;
static void (* const self_set_layer) (SandWindow * self, GnomeWinLayer layer) = sand_window_set_layer;
static void (* const init_color) (SandWindow * self, guint8 r, guint8 g, guint8 b) = sand_window_init_color;
static void (* const self_init_color) (SandWindow * self, guint8 r, guint8 g, guint8 b) = sand_window_init_color;
static void (* const set_mask) (SandWindow * self, double q) = sand_window_set_mask;
static void (* const self_set_mask) (SandWindow * self, double q) = sand_window_set_mask;
static void (* const redraw) (SandWindow * self) = sand_window_redraw;
static void (* const self_redraw) (SandWindow * self) = sand_window_redraw;
static void (* const refill) (SandWindow * self) = sand_window_refill;
static void (* const self_refill) (SandWindow * self) = sand_window_refill;
static void (* const init_sand) (SandWindow * self) = sand_window_init_sand;
static void (* const self_init_sand) (SandWindow * self) = sand_window_init_sand;
static void (* const get_color) (SandWindow * self, guint8 * r, guint8 * g, guint8 * b) = sand_window_get_color;
static void (* const self_get_color) (SandWindow * self, guint8 * r, guint8 * g, guint8 * b) = sand_window_get_color;
static void (* const set_color) (SandWindow * self, guint8 r, guint8 g, guint8 b) = sand_window_set_color;
static void (* const self_set_color) (SandWindow * self, guint8 r, guint8 g, guint8 b) = sand_window_set_color;
static void (* const flood) (SandWindow * self, double q) = sand_window_flood;
static void (* const self_flood) (SandWindow * self, double q) = sand_window_flood;

/* a macro for creating a new object of our type */
#define GET_NEW ((SandWindow *)gtk_type_new(sand_window_get_type()))

static void 
sand_window_class_init (SandWindowClass * c)
{
#define __GOB_FUNCTION__ "Sand:Window::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) c;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) c;
#endif /* G_OBJECT_CLASS */
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;

	parent_class = gtk_type_class (gtk_window_get_type ());

#line 112 "../gob/sand-window.gob"
	gtk_widget_class->size_request = ___2_sand_window_size_request;
#line 158 "../gob/sand-window.gob"
	gtk_widget_class->realize = ___4_sand_window_realize;
#line 276 "../gob/sand-window.gob"
	gtk_object_class->destroy = ___7_sand_window_destroy;
#line 193 "sand-window.c"

	gtk_object_add_arg_type("SandWindow::decorations",
		GTK_TYPE_BOOL,
		GTK_ARG_READWRITE,
		ARG_DECORATIONS);

	gtk_object_class->get_arg = ___object_get_arg;
	gtk_object_class->set_arg = ___object_set_arg;
	return;
	c = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__
#line 204 "../gob/sand-window.gob"
static void 
sand_window_init (SandWindow * swindow)
#line 213 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::init"
#line 43 "../gob/sand-window.gob"
	swindow->layer = WIN_LAYER_NORMAL;
#line 218 "sand-window.c"
 {
#line 204 "../gob/sand-window.gob"

    char *fname;
    GdkImlibImage *back, *sand, *front;
  
    /* Set the window policy */
    gtk_window_set_policy (GTK_WINDOW (swindow), FALSE, FALSE, TRUE);
    gtk_window_set_wmclass (GTK_WINDOW (swindow),
			    "sandUhrTimer", "SandUhrTimer");

    /* Create the canvas */
    gtk_widget_push_visual (gdk_rgb_get_visual ());
    gtk_widget_push_colormap (gdk_rgb_get_cmap ());
    swindow->canvas = gnome_canvas_new_aa ();
    gtk_widget_pop_colormap ();
    gtk_widget_pop_visual ();

    gtk_container_add (GTK_CONTAINER (swindow), swindow->canvas);
    gtk_widget_show (swindow->canvas);

    /* Create the image items */
    fname = get_pixmap_file ("back.png");
    back = gdk_imlib_load_image (fname);
    g_free (fname);
    swindow->back
      = gnome_canvas_item_new(gnome_canvas_root(GNOME_CANVAS(swindow->canvas)),
			      gnome_canvas_image_get_type (),
			      "image", back,
			      "width", (double) back->rgb_width,
			      "height", (double) back->rgb_height,
			      "anchor", GTK_ANCHOR_NW,
			      NULL);
  
    fname = get_pixmap_file ("mask.png");
    sand = gnome_canvas_load_alpha (fname);
    g_free (fname);
    swindow->sand = sand;
    swindow->mask = g_malloc (sand->rgb_width*sand->rgb_height);
    memcpy (swindow->mask, sand->alpha_data, sand->rgb_width*sand->rgb_height);
    init_sand (swindow);
    swindow->mid
      = gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS(swindow->canvas)),
			       gnome_canvas_image_get_type (),
			       "image", sand,
			       "width", (double) sand->rgb_width,
			       "height", (double) sand->rgb_height,
			       "anchor", GTK_ANCHOR_NW,
			       NULL);

    fname = get_pixmap_file ("front.png");
    front = gnome_canvas_load_alpha (fname);
    g_free (fname);
    swindow->front
      = gnome_canvas_item_new(gnome_canvas_root(GNOME_CANVAS(swindow->canvas)),
			      gnome_canvas_image_get_type (),
			      "anchor", GTK_ANCHOR_NW,
			      "image", front,
			      "width", (double) front->rgb_width,
			      "height", (double) front->rgb_height,
			      NULL);

    gtk_signal_connect (GTK_OBJECT (swindow), "size_allocate",
			(GtkSignalFunc) size_allocate_handler,
			NULL);

    swindow->ratio = 0.0;
    swindow->r = 0;
    swindow->g = 0;
    swindow->b = 0;

    swindow->decorations = FALSE;
  
#line 292 "sand-window.c"
 }
	return;
	swindow = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_set_arg (GtkObject *object,
	GtkArg *arg,
	guint arg_id)
#define __GOB_FUNCTION__ "Sand:Window::set_arg"
{
	SandWindow *self;

	self = SAND_WINDOW (object);

	switch (arg_id) {
	case ARG_DECORATIONS:
#define ARG (GTK_VALUE_BOOL(*arg))
		{
#line 42 "../gob/sand-window.gob"
 self->decorations = ARG; set_decorations (self); 
#line 315 "sand-window.c"
		}
		break;
#undef ARG
	default:
		break;
	}
	return;
	self = NULL;
	arg = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_get_arg (GtkObject *object,
	GtkArg *arg,
	guint arg_id)
#define __GOB_FUNCTION__ "Sand:Window::get_arg"
{
	SandWindow *self;

	self = SAND_WINDOW (object);

	switch (arg_id) {
	case ARG_DECORATIONS:
#define ARG (GTK_VALUE_BOOL(*arg))
		{
#line 43 "../gob/sand-window.gob"
 ARG = self->decorations; 
#line 344 "sand-window.c"
		}
		break;
#undef ARG
	default:
		break;
	}
	return;
	self = NULL;
	arg = NULL;
}
#undef __GOB_FUNCTION__


#line 69 "../gob/sand-window.gob"
static void 
sand_window_create_shape (SandWindow * self, int image_width, int image_height)
#line 361 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::create_shape"
#line 69 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 69 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 368 "sand-window.c"
{
#line 71 "../gob/sand-window.gob"
	
    GdkImlibImage *im;
    GdkBitmap *mask;
    GdkBitmap *im_mask;
    GdkGC *mgc;
    GdkColor c;

    /* Create the initial mask and clear it */
    mask = gdk_pixmap_new (GTK_WIDGET (self)->window,
			   image_width, image_height, 1);

    mgc = gdk_gc_new (mask);
    c.pixel = 0;
    gdk_gc_set_foreground (mgc, &c);
    gdk_draw_rectangle (mask, mgc, TRUE, 0, 0, image_width, image_height);

    c.pixel = 1;
    gdk_gc_set_foreground (mgc, &c);

    /* Paint the mask of the image */
    im = GNOME_CANVAS_IMAGE (self->back)->im;
    gdk_imlib_render (im, image_width, image_height);
    im_mask = gdk_imlib_move_mask (im);

    if (im_mask) {
      gdk_draw_pixmap (mask, mgc, im_mask,
		       0, 0, 0, 0, image_width, image_height);
      gdk_imlib_free_bitmap (im_mask);
    } else {
      gdk_draw_rectangle (mask, mgc, TRUE,
			  0, 0, image_width, image_height);
    }

    if (!GTK_WIDGET_REALIZED (self))
      gtk_widget_realize (GTK_WIDGET (self));

    gtk_widget_shape_combine_mask (GTK_WIDGET (self), mask, 0, 0);
    gdk_bitmap_unref (mask);
    gdk_gc_unref (mgc);
  }}
#line 411 "sand-window.c"
#undef __GOB_FUNCTION__

#line 112 "../gob/sand-window.gob"
static void 
___2_sand_window_size_request (GtkWidget * widget, GtkRequisition * requisition)
#line 417 "sand-window.c"
#define PARENT_HANDLER(___widget,___requisition) \
	{ if(GTK_WIDGET_CLASS(parent_class)->size_request) \
		(* GTK_WIDGET_CLASS(parent_class)->size_request)(___widget,___requisition); }
{
#define __GOB_FUNCTION__ "Sand:Window::size_request"
#line 112 "../gob/sand-window.gob"
	g_return_if_fail (widget != NULL);
#line 425 "sand-window.c"
{
#line 114 "../gob/sand-window.gob"
	
    SandWindow *self;
    GtkArg args[2];

    self = SAND_WINDOW (widget);
    
    /* Get size of icon image */
    args[0].name = "width";
    args[1].name = "height";
    gtk_object_getv (GTK_OBJECT (self->back), 2, args);
    requisition->width = GTK_VALUE_DOUBLE (args[0]);
    requisition->height = GTK_VALUE_DOUBLE (args[1]);
  }}
#line 441 "sand-window.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 128 "../gob/sand-window.gob"
static void 
sand_window_drop_handler (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * selection_data, guint info, guint time, gpointer data)
#line 448 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::drop_handler"
{
#line 137 "../gob/sand-window.gob"
	
    SandWindow *sand_window = SAND_WINDOW (widget);
    guint16 *vals;
    gdouble  r, g, b;

    if (selection_data->length < 0) return;

    if ((selection_data->format != 16) || (selection_data->length != 8)) {
      g_warning ("Received invalid color data");
      return;
    }
  
    vals = (guint16 *)selection_data->data;

    r = (gdouble)vals[0] / 0xffff;
    g = (gdouble)vals[1] / 0xffff;
    b = (gdouble)vals[2] / 0xffff;
  
    set_color (sand_window, r*255, g*255, b*255);
  }}
#line 473 "sand-window.c"
#undef __GOB_FUNCTION__

#line 158 "../gob/sand-window.gob"
static void 
___4_sand_window_realize (GtkWidget * widget)
#line 479 "sand-window.c"
#define PARENT_HANDLER(___widget) \
	{ if(GTK_WIDGET_CLASS(parent_class)->realize) \
		(* GTK_WIDGET_CLASS(parent_class)->realize)(___widget); }
{
#define __GOB_FUNCTION__ "Sand:Window::realize"
#line 158 "../gob/sand-window.gob"
	g_return_if_fail (widget != NULL);
#line 487 "sand-window.c"
{
#line 160 "../gob/sand-window.gob"
	
    GdkPixmap *icon;
    static const GtkTargetEntry targets[] = {
      { "application/x-color", 0 }
    };

    g_return_if_fail (SAND_IS_WINDOW (widget));

    PARENT_HANDLER (widget);

    /* Set the proper GNOME hints */
    gnome_win_hints_init ();
    icon = gdk_bitmap_create_from_data (widget->window, icon24_bits,
				        icon24_width, icon24_height);
    gdk_window_set_icon (widget->window, NULL, icon, NULL);
    gdk_window_set_functions (widget->window, GDK_FUNC_MOVE|GDK_FUNC_CLOSE);
    set_decorations (SAND_WINDOW (widget));
    if (gnome_win_hints_wm_exists ()) {
      gnome_win_hints_set_hints(widget, WIN_HINTS_DO_NOT_COVER);
      gnome_win_hints_set_layer (widget, SAND_WINDOW (widget)->layer);
    }

    gtk_drag_dest_set (widget, GTK_DEST_DEFAULT_ALL,
		       targets, 1, GDK_ACTION_COPY);
  
    gtk_signal_connect (GTK_OBJECT (widget),
			"drag_data_received",
			GTK_SIGNAL_FUNC (drop_handler),
			NULL);
  }}
#line 520 "sand-window.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 191 "../gob/sand-window.gob"
static void 
sand_window_size_allocate_handler (GtkWidget * widget, GtkAllocation * allocation, gpointer data)
#line 527 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::size_allocate_handler"
{
#line 194 "../gob/sand-window.gob"
	
    SandWindow *self;

    self = SAND_WINDOW (widget);
    gnome_canvas_set_scroll_region (GNOME_CANVAS(self->canvas),
				    0, 0,
				    allocation->width, allocation->height);
    create_shape (self, allocation->width, allocation->height);
  }}
#line 541 "sand-window.c"
#undef __GOB_FUNCTION__


#line 276 "../gob/sand-window.gob"
static void 
___7_sand_window_destroy (GtkObject * object)
#line 548 "sand-window.c"
#define PARENT_HANDLER(___object) \
	{ if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(___object); }
{
#define __GOB_FUNCTION__ "Sand:Window::destroy"
#line 276 "../gob/sand-window.gob"
	g_return_if_fail (object != NULL);
#line 556 "sand-window.c"
{
#line 278 "../gob/sand-window.gob"
	
    SandWindow *self;
    
    self = SAND_WINDOW (object);
    g_free (self->mask);
    self->mask = NULL;
    PARENT_HANDLER (object);
  }}
#line 567 "sand-window.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 287 "../gob/sand-window.gob"
GtkWidget * 
sand_window_new (void)
#line 574 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::new"
{
#line 289 "../gob/sand-window.gob"
	
    GtkWidget *ret;
    
    ret = GTK_WIDGET (GET_NEW);
    return  ret;
  }}
#line 585 "sand-window.c"
#undef __GOB_FUNCTION__

#line 300 "../gob/sand-window.gob"
static void 
sand_window_set_decorations (SandWindow * self)
#line 591 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::set_decorations"
#line 300 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 300 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 598 "sand-window.c"
{
#line 302 "../gob/sand-window.gob"
	
    GtkWidget *widget = GTK_WIDGET (self);
    gboolean  fix_broken_wm;
    gint x, y;

    if (! GTK_WIDGET_REALIZED (self))  return;

    /* work around broken window managers */
    fix_broken_wm = GTK_WIDGET_MAPPED (self);
    if (fix_broken_wm) {
      gdk_window_get_position (widget->window, &x, &y);
      gdk_window_hide (widget->window);
    }

    if (self->decorations) {
      gdk_window_set_decorations (widget->window, GDK_DECOR_TITLE);
    } else {
      gdk_window_set_decorations (widget->window, 0);
    }

    if (fix_broken_wm) {
      gdk_window_show (widget->window);
      gdk_window_move (widget->window, x, y);
    }
  }}
#line 626 "sand-window.c"
#undef __GOB_FUNCTION__

#line 328 "../gob/sand-window.gob"
GnomeWinLayer 
sand_window_get_layer (SandWindow * self)
#line 632 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::get_layer"
#line 328 "../gob/sand-window.gob"
	g_return_val_if_fail (self != NULL, (GnomeWinLayer )0);
#line 328 "../gob/sand-window.gob"
	g_return_val_if_fail (SAND_IS_WINDOW (self), (GnomeWinLayer )0);
#line 639 "sand-window.c"
{
#line 330 "../gob/sand-window.gob"
	
    if (gnome_win_hints_wm_exists ()) {
      return  gnome_win_hints_get_layer (GTK_WIDGET(self));
    }
    return  -1;
  }}
#line 648 "sand-window.c"
#undef __GOB_FUNCTION__

#line 337 "../gob/sand-window.gob"
void 
sand_window_set_layer (SandWindow * self, GnomeWinLayer layer)
#line 654 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::set_layer"
#line 337 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 337 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 661 "sand-window.c"
{
#line 339 "../gob/sand-window.gob"
	
    self->layer = layer;
    if (GTK_WIDGET_REALIZED (self) && gnome_win_hints_wm_exists ()) {
      gnome_win_hints_set_layer (GTK_WIDGET(self), layer);
    }
  }}
#line 670 "sand-window.c"
#undef __GOB_FUNCTION__

#line 350 "../gob/sand-window.gob"
static void 
sand_window_init_color (SandWindow * self, guint8 r, guint8 g, guint8 b)
#line 676 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::init_color"
#line 350 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 350 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 683 "sand-window.c"
{
#line 353 "../gob/sand-window.gob"
	
    GdkImlibImage *sand = self->sand;
    int  i;

    for (i=0; i<sand->rgb_width*sand->rgb_height; ++i) {
      sand->rgb_data [3*i] = r;
      sand->rgb_data [3*i+1] = g;
      sand->rgb_data [3*i+2] = b;
    }
  }}
#line 696 "sand-window.c"
#undef __GOB_FUNCTION__

#line 364 "../gob/sand-window.gob"
static void 
sand_window_set_mask (SandWindow * self, double q)
#line 702 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::set_mask"
#line 364 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 364 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 709 "sand-window.c"
{
#line 366 "../gob/sand-window.gob"
	
    GdkImlibImage *sand = self->sand;
    int  width = sand->rgb_width;
    int  height = sand->rgb_height;
    double  a, rest;
    int  i, j;

    if (! self->mask)  return;

    /* upper chamber */
    a = 0;
    rest = self->A-(1-q)*self->fill;
    for (j=0; j<height/2; ++j) {
      double  current = 0;

      if (a >= rest) {
	/* row is completely filled */
	for (i=0; i<width; ++i) {
	  sand->alpha_data[j*width+i] = self->mask[j*width+i];
	}
      } else {
	for (i=0; i<width; ++i)  current += self->mask[j*width+i]/255.0;
	a += current;
	if (a >= rest) {
	  /* row is partially filled */
	  double  x = (a - rest)/current;
	  for (i=0; i<width; ++i) {
	    sand->alpha_data[j*width+i] = x*self->mask[j*width+i];
	  }
	} else {
	  /* row is completely empty */
	  for (i=0; i<width; ++i) {
	    sand->alpha_data[j*width+i] = 0;
	  }
	}
      }
    }

    /* lower chamber */
    a = 0;
    rest = self->B-q*self->fill;
    for (j=height/2; j<height; ++j) {
      double  current = 0;

      if (a >= rest) {
	/* row is completely filled */
	for (i=0; i<width; ++i) {
	  mask_set_value (sand->alpha_data, self->mask, 1,
			  width, height, i, j);
	}
      } else {
	for (i=0; i<width; ++i) {
	  current += mask_get_value (self->mask, width, height, i, j);
	}
	a += current;
	if (a >= rest) {
	  /* row is partially filled */
	  double  x = (a - rest)/current;
	  for (i=0; i<width; ++i) {
	    mask_set_value (sand->alpha_data, self->mask, x,
			    width, height, i, j);
	  }
	} else {
	  /* row is completely empty */
	  for (i=0; i<width; ++i) {
	    mask_set_value (sand->alpha_data, self->mask, 0,
			    width, height, i, j);
	  }
	  if (q<0.995) sand->alpha_data[j*width+width/2] = 48;
	}
      }
    }
  }}
#line 785 "sand-window.c"
#undef __GOB_FUNCTION__

#line 440 "../gob/sand-window.gob"
static void 
sand_window_redraw (SandWindow * self)
#line 791 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::redraw"
#line 440 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 440 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 798 "sand-window.c"
{
#line 442 "../gob/sand-window.gob"
	
    gtk_object_set (GTK_OBJECT (self->mid),
		    "image", self->sand,
		    NULL);
  }}
#line 806 "sand-window.c"
#undef __GOB_FUNCTION__

#line 448 "../gob/sand-window.gob"
static void 
sand_window_refill (SandWindow * self)
#line 812 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::refill"
#line 448 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 448 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 819 "sand-window.c"
{
#line 450 "../gob/sand-window.gob"
	
    init_color (self, self->r, self->g, self->b);
    set_mask (self, self->ratio);
    redraw (self);
  }}
#line 827 "sand-window.c"
#undef __GOB_FUNCTION__

#line 456 "../gob/sand-window.gob"
static void 
sand_window_init_sand (SandWindow * self)
#line 833 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::init_sand"
#line 456 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 456 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 840 "sand-window.c"
{
#line 458 "../gob/sand-window.gob"
	
    GdkImlibImage *sand = self->sand;
    double  A=0, B=0, fill;
    int  i, mid;

    g_assert (self->mask);
    init_color (self, self->r, self->g, self->b);

    mid = sand->rgb_height/2;
    for (i=0; i<sand->rgb_width*mid; ++i) {
      A += self->mask [i]/255.0;
    }
    for (i=sand->rgb_width*mid; i<sand->rgb_width*sand->rgb_height; ++i) {
      B += self->mask [i]/255.0;
    }

    fill = 0.9*MIN(A,B);
    g_assert (fill >= 50);
    self->A = A;
    self->B = B;
    self->fill = fill;
  
    /* TODO: do the remaining stuff */
    self->ratio = 1;
    set_mask (self, 0);
  }}
#line 869 "sand-window.c"
#undef __GOB_FUNCTION__

#line 489 "../gob/sand-window.gob"
void 
sand_window_get_color (SandWindow * self, guint8 * r, guint8 * g, guint8 * b)
#line 875 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::get_color"
#line 489 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 489 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 882 "sand-window.c"
{
#line 491 "../gob/sand-window.gob"
	
    *r = self->r;
    *g = self->g;
    *b = self->b;
  }}
#line 890 "sand-window.c"
#undef __GOB_FUNCTION__

#line 497 "../gob/sand-window.gob"
void 
sand_window_set_color (SandWindow * self, guint8 r, guint8 g, guint8 b)
#line 896 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::set_color"
#line 497 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 497 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 903 "sand-window.c"
{
#line 499 "../gob/sand-window.gob"
	
    self->r = r;
    self->g = g;
    self->b = b;
    refill (self);
  }}
#line 912 "sand-window.c"
#undef __GOB_FUNCTION__

#line 506 "../gob/sand-window.gob"
void 
sand_window_flood (SandWindow * self, double q)
#line 918 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::flood"
#line 506 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 506 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 925 "sand-window.c"
{
#line 508 "../gob/sand-window.gob"
	
    if (q <= 0)  q = 0;
    if (q >= 1)  q = 1;
    
    self->ratio = q;
    refill (self);
  }}
#line 935 "sand-window.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___sand_window_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))create_shape)();
	((void (*)(void))drop_handler)();
	((void (*)(void))size_allocate_handler)();
	((void (*)(void))new)();
	((void (*)(void))set_decorations)();
	((void (*)(void))get_layer)();
	((void (*)(void))set_layer)();
	((void (*)(void))init_color)();
	((void (*)(void))set_mask)();
	((void (*)(void))redraw)();
	((void (*)(void))refill)();
	((void (*)(void))init_sand)();
	((void (*)(void))get_color)();
	((void (*)(void))set_color)();
	((void (*)(void))flood)();
	___sand_window_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

