/**************************************************************************/
/*                                                                        */
/*  parsecfg - a library for parsing a configuration file                 */
/*  Copyright (C) 1999-2002 Yuuki NINOMIYA <gm@debian.or.jp>              */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2, or (at your option)   */
/*  any later version.                                                    */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful,       */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*  GNU General Public License for more details.                          */
/*                                                                        */
/*  You should have received a copy of the GNU General Public License     */
/*  along with this program; if not, write to the                         */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,          */
/*  Boston, MA 02111-1307, USA.                                           */
/*                                                                        */
/**************************************************************************/

/* $Id: sample.c,v 1.8 2002/02/13 09:01:01 gm Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include "parsecfg.h"		/* include this header file when use parsecfg library */


/************************/
/*    for CFG_SIMPLE    */
/************************/

/* variables stored got value */

/* If there is no parameter in the configuration file,
   the value is not changed.
   However if linked list isn't set initial value,
   it must be initialized as NULL. */

int cfg_bool;
int cfg_int;
int cfg_int_not_change = 489;
unsigned int cfg_uint;
float cfg_float;
double cfg_double;
long cfg_long;
unsigned long cfg_ulong;
char *cfg_str;			/* pointer to string (Memories stored real string is allocated dynamically.) */
cfgList *cfg_list = NULL;	/* pointer to linked list */


/* array of cfgStruct */

cfgStruct cfg[] = {		/* this must be initialized */
	/* parameter  type       address of variable */
	{"BOOL",     CFG_BOOL,        &cfg_bool},
	{"INT",      CFG_INT,         &cfg_int},
	{"UINT",     CFG_UINT,        &cfg_uint},
	{"LONG",     CFG_LONG,        &cfg_long},
	{"ULONG",    CFG_ULONG,       &cfg_ulong},
	{"FLOAT",    CFG_FLOAT,       &cfg_float},
	{"DOUBLE",   CFG_DOUBLE,      &cfg_double},
	{"STR",      CFG_STRING,      &cfg_str},
	{"LIST",     CFG_STRING_LIST, &cfg_list},
	{"NoChange", CFG_INT,         &cfg_int_not_change},
	{NULL, CFG_END, NULL}	/* no more parameters */
};



/************************/
/*     for CFG_INI      */
/************************/

/* variables stored got value */

/* If there is no parameter in the configuration file,
   the value is initialized 0 or NULL (boolean value is
   initialized -1(FALSE)). */

int *ini_bool;
int *ini_int;
unsigned int *ini_uint;
long *ini_long;
unsigned long *ini_ulong;
float *ini_float;
double *ini_double;
char **ini_str;
cfgList **ini_list;


/* array of cfgStruct */

cfgStruct cfgini[] = {
	/* parameter  type  address of variable */
	{"BOOL",   CFG_BOOL,   &ini_bool},
	{"INT",    CFG_INT,    &ini_int},
	{"UINT",   CFG_UINT,   &ini_uint},
	{"LONG",   CFG_LONG,   &ini_long},
	{"ULONG",  CFG_ULONG,  &ini_ulong},
	{"FLOAT",  CFG_FLOAT,  &ini_float},
	{"DOUBLE", CFG_DOUBLE, &ini_double},
	{"STR",    CFG_STRING, &ini_str},
	{"LIST",   CFG_STRING_LIST, &ini_list},
	{NULL, CFG_END, NULL}	/* no more parameters */
};


int main(void)
{
	cfgList *l;
	cfgList *next;
	int max, i;
	int a;
	float f;
	char *b;
	cfgList *c = NULL;	/* cfgList for fetchVarFromCfgFile() must be initialized as NULL */


/* --- PARSE/DUMP SIMPLE FILE --- */
	if (cfgParse("sample.cfg", cfg, CFG_SIMPLE) == -1) {
		printf("an error was detected\n");
		return 1;
	}

	printf("BOOL  : %s\n", cfg_bool ? "TRUE" : "FALSE");	/* 1 is "TRUE", 0 is "FALSE" */
	printf("INT   : %d\n", cfg_int);
	printf("NoChange : %d\n", cfg_int_not_change);
	printf("UINT  : %u\n", cfg_uint);
	printf("LONG  : %ld\n", cfg_long);
	printf("ULONG : %lu\n", cfg_ulong);
	printf("FLOAT : %f\n", cfg_float);
	printf("DOUBLE: %f\n", cfg_double);
	printf("STR   : %s\n", cfg_str);

	l = cfg_list;
	if (l != NULL) {
		for (;;) {
			printf("LIST  : %s\n", l->str);
			if (l->next == NULL) {
				break;
			}
			l = l->next;
		}
	}

	cfgDump("sample.cfg.dump", cfg, CFG_SIMPLE, 0);

	free(cfg_str);
	for (l = cfg_list; l != NULL;) {
		free(l->str);
		next = l->next;
		free(l);
		l = next;
	}
	free(c);


/* --- PARSE/DUMP INI FILE --- */
	max = cfgParse("sample.ini", cfgini, CFG_INI);
	if (max == -1) {
		printf("an error was detected\n");
		return 1;
	}

	max = cfgAllocForNewSection(cfgini, "added section");
	cfgStoreValue(cfgini, "STR", "Windoze NoThanks", CFG_INI, cfgSectionNameToNumber("added section"));
	cfgStoreValue(cfgini, "LONG", "999999999", CFG_INI, max - 1);
	cfgStoreValue(cfgini, "BOOL", "FALSE", CFG_INI, max - 1);

	printf("\n\n\nmax=%d\n", max);
	for (i = 0; i < max; i++) {
		printf("\n[%s]\n", cfgSectionNumberToName(i));

		printf("BOOL  : %s\n", ini_bool[i] ? "TRUE" : "FALSE");	/* 1 is "TRUE", 0 is "FALSE" */
		printf("INT   : %d\n", ini_int[i]);
		printf("UINT  : %u\n", ini_uint[i]);
		printf("LONG  : %ld\n", ini_long[i]);
		printf("ULONG : %lu\n", ini_ulong[i]);
		printf("FLOAT : %f\n", ini_float[i]);
		printf("DOUBLE: %f\n", ini_double[i]);
		printf("STR   : %s\n", ini_str[i]);

		if (ini_list[i] == NULL) {
			continue;
		}
		for (l = ini_list[i]; l != NULL; l = l->next) {
			printf("LIST  : %s\n", l->str);
		}
	}
	printf("\nSection name [LiNuX] is No.%d\n", cfgSectionNameToNumber("LiNuX"));
	printf("Section name [GNU project] is No.%d\n", cfgSectionNameToNumber("GNU project"));

	cfgDump("sample.ini.dump", cfgini, CFG_INI, max);


/* --- FETCH SIMPLE FILE --- */
	printf("\n-- fetchVarFromCfgFile() with sample.cfg --\n");
	if (fetchVarFromCfgFile("sample.cfg", "INT", &a, CFG_INT, CFG_SIMPLE, 0, NULL) == 0) {
		printf("INT: %d\n", a);
	}
	if (fetchVarFromCfgFile("sample.cfg", "FLOAT", &f, CFG_FLOAT, CFG_SIMPLE, 0, NULL) == 0) {
		printf("Float: %f\n", f);
	}
	if (fetchVarFromCfgFile("sample.cfg", "str", &b, CFG_STRING, CFG_SIMPLE, 0, NULL) == 0) {
		printf("STR: %s\n", b);
		free(b);
	}
	if (fetchVarFromCfgFile("sample.cfg", "LIsT", &c, CFG_STRING_LIST, CFG_SIMPLE, 0, NULL) == 0) {
		for (l = c; l != NULL; l = l->next) {
			printf("LIST: %s\n", l->str);
		}
		printf("%d\n", fetchVarFromCfgFile("sample.cfg", "NoSuchParameter", &a, CFG_INT, CFG_SIMPLE, 0, NULL));
	}
	for (l = c; l != NULL;) {
		free(l->str);
		next = l->next;
		free(l);
		l = next;
	}


/* --- FETCH INI FILE --- */
	c = NULL;
	printf("\n-- fetchVarFromCfgFile() with sample.ini --\n");
	if (fetchVarFromCfgFile("sample.ini", "INT", &a, CFG_INT, CFG_INI, 2, NULL) == 0) {
		printf("INT: %d\n", a);
	}
	if (fetchVarFromCfgFile("sample.ini", "FLOAT", &f, CFG_FLOAT, CFG_INI, 2, NULL) == 0) {
		printf("FLOAT: %f\n", f);
	}
	if (fetchVarFromCfgFile("sample.ini", "str", &b, CFG_STRING, CFG_INI, 0, "linux") == 0) {
		printf("STR: %s\n", b);
		free(b);
	}
	if (fetchVarFromCfgFile("sample.ini", "LIsT", &c, CFG_STRING_LIST, CFG_INI, 1, NULL) == 0) {
		for (l = c; l != NULL;) {
			printf("LIST: %s\n", l->str);
			free(l->str);
			next = l->next;
			free(l);
			l = next;
		}
	}

	printf("%d\n", fetchVarFromCfgFile("sample.ini", "NoSuchParameter", &a, CFG_INT, CFG_INI, 0, "FSF GNU"));
	printf("%d\n", fetchVarFromCfgFile("sample.ini", "int", &a, CFG_INT, CFG_INI, 0, "NoSuchSection"));


/* --- TEST FOR DEALLOCATING MEMORY --- */
	cfgFree(cfgini, CFG_INI, max);

	max = cfgParse("sample.ini", cfgini, CFG_INI);
	if (max == -1) {
		printf("an error was detected\n");
		return 1;
	}

	cfgFree(cfgini, CFG_INI, max);

	return (0);
}
