% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-all.R, R/test-getting-started.R,
%   R/test-driver.R, R/test-connection.R, R/test-result.R, R/test-sql.R,
%   R/test-meta.R, R/test-transaction.R, R/test-compliance.R, R/test-stress.R
\name{test_all}
\alias{test_all}
\title{Run all tests}
\usage{
test_all(skip = NULL, ctx = get_default_context())
}
\arguments{
\item{skip}{\code{[character()]}\cr A vector of regular expressions to match
against test names; skip test if matching any.}

\item{ctx}{\code{[DBItest_context]}\cr A test context as created by
\code{\link[=make_context]{make_context()}}.}
}
\description{
This function calls all tests defined in this package (see the section
"Tests" below).
}
\section{Tests}{

This function runs the following tests, except the stress tests:


\code{\link[=test_getting_started]{test_getting_started()}}:
Getting started with testing


\code{\link[=test_driver]{test_driver()}}:
Test the "Driver" class


\code{\link[=test_connection]{test_connection()}}:
Test the "Connection" class


\code{\link[=test_result]{test_result()}}:
Test the "Result" class


\code{\link[=test_sql]{test_sql()}}:
Test SQL methods


\code{\link[=test_meta]{test_meta()}}:
Test metadata functions


\code{\link[=test_transaction]{test_transaction()}}:
Test transaction functions


\code{\link[=test_compliance]{test_compliance()}}:
Test full compliance to DBI


\code{\link[=test_stress]{test_stress()}}:
Stress tests (not tested with \code{test_all})
}

