#ifndef REC_APPLET_H
#define REC_APPLET_H

#include <applet-widget.h>

#define REC_LINE (1<<0)
#define REC_MIC  (1<<1)
#define REC_CD   (1<<2)

typedef struct Properties_ Properties;
struct Properties_ {
	gint rate;
	gint bits;
	gboolean stereo;
	gint source;
	gfloat prerec_amount;
	/* Not used in record.c: */
	gboolean start_prerec;
	/* File saving: */
	gchar *filename;      /* In printf-style format always */
	gint filestart;       /* Starting value, -1 for printf-format,
				 -2 for non-number/printf */
};

/* In record.c: */

extern gboolean recording,buffering;

extern gboolean record_start_prerecord(void);
extern void record_stop_prerecord(void);
extern gboolean record_start_record(gchar *file);
extern void record_stop_record(void);

extern void record_set_options(Properties *props);

/* In properties.c: */

extern void properties(AppletWidget *applet,gpointer data);
extern void parse_to_printf_string(Properties *props, gchar *str);

/* In error.c: */
/* (a bit horrible, yes...) */

void error_no_file(void);
void error_open(void);
void error_sound(void);


/* DEBUG HELPER MACROS: */
#define dbg() g_print("file %s: line %d (%s): got here\n", \
			 __FILE__,__LINE__,G_GNUC_PRETTY_FUNCTION)
#define dbg_brk() g_print("---\n");
#define dbg_msg(msg) g_print("file %s: line %d (%s): %s\n", \
			     __FILE__,__LINE__,G_GNUC_PRETTY_FUNCTION,msg);
#define dbg_addr(expr) g_print("file %s: line %d (%s): addr %s=0x%X\n", \
			       __FILE__,__LINE__,G_GNUC_PRETTY_FUNCTION, \
                               #expr, \
			       (gint)expr)
#define dbg_str(expr) G_STMT_START { \
	g_print("file %s: line %d (%s): %s=", \
		__FILE__,__LINE__,G_GNUC_PRETTY_FUNCTION,#expr); \
        g_print("%s\n",expr); \
       } G_STMT_END
#define dbg_int(expr) g_print("file %s: line %d (%s): %s=%d\n", \
			      __FILE__,__LINE__,G_GNUC_PRETTY_FUNCTION, \
                              #expr, \
			      expr)


#endif /* REC_APPLET_H */

