/**********************************************************************
 *
 *	FILE:			ViewPoint.cpp
 *
 *	DESCRIPTION:	Read/Write osg::ViewPoint in binary format to disk.
 *
 *	CREATED BY:		Auto generated by iveGenerate
 *					and later modified by Rune Schmidt Jensen.
 *
 *	HISTORY:		Created 24.3.2003
 *
 *	Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "ViewPoint.h"
#include "PositionAttitudeTransform.h"

using namespace ive;

void ViewPoint::write(DataOutputStream* out){
	// Write ViewPoint's identification.
	out->writeInt(IVEVIEWPOINT);
	// If the osg class is inherited by any other class we should also write this to file.
	osg::PositionAttitudeTransform*  pat = dynamic_cast<osg::PositionAttitudeTransform*>(this);
	if(pat){
		((ive::PositionAttitudeTransform*)(pat))->write(out);
	}
	else
		throw Exception("ViewPoint::write(): Could not cast this osg::ViewPoint to an osg::PositionAttitudeTransform.");
	// Write ViewPoint's properties.
}

void ViewPoint::read(DataInputStream* in){
	// Peek on ViewPoint's identification.
	int id = in->peekInt();
	if(id == IVEVIEWPOINT){
		// Read ViewPoint's identification.
		id = in->readInt();
		// If the osg class is inherited by any other class we should also read this from file.
		osg::PositionAttitudeTransform*  pat = dynamic_cast<osg::PositionAttitudeTransform*>(this);
		if(pat){
			((ive::PositionAttitudeTransform*)(pat))->read(in);
		}
		else
			throw Exception("ViewPoint::read(): Could not cast this osg::ViewPoint to an osg::PositionAttitudeTransform.");
		// Read ViewPoint's properties
	}
	else{
		throw Exception("ViewPoint::read(): Expected ViewPoint identification.");
	}
}
