#
# job-funcs.pl
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is released under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: job-funcs.pl,v 1.13 2001/08/29 22:23:03 adam Exp $

use CGI qw(:standard);
require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';
use ADB;



sub reset_all_params {
    # gonna need to reset approved to the client default!
    param('job_id'            ,'');
    param('date_entered'      ,&date_today);
    param('time_in'           ,'##:##');
    param('time_out'          ,'##:##');
    param('total_hours'       ,'');
    param('parking'           ,'');
    param('hours_description' ,'');
    param('comment'           ,'');
    param('billable'          ,'');
    param('approved'          ,'');
}


#############
# admin_search_jobs_form takes a hash with the following values
#
# remote_user is the user from the REMOTE_USER ENV var
# client_name is the name of the currently selected client, NOT ID
# client_id is the unique ID for the client
# today is today's date in dd/mm/yy format
# supers = reference to list of superusers
sub admin_search_job_form {
    my %args = @_;
    my $superref = $args{'supers'};
    my @supers = @$superref;
    my %yes_no_labels = ('y',' Yes','n',' No', 'any', 'Any');
    my %client_labels = ($args{'client_id'}, $args{'client_name'},'any','Any Client');
    my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        my $oops = $dbconn->errorstring;
        &error("Cannot connect to backend: $oops");
    }
    my @categories = $dbconn->list('category_id',$Conf::CATEGORY_DB,);

    $dbconn->close;
 
    # Push something onto supers to give them the "any" option
    push @supers, "any";

    # And the same for categories
    push (@categories, "any"); 

    # It's widget makin with Martha stewart, "It's a good thing"
    my %widgets;
    $widgets{'fkclient_id'} = radio_group('-name'=>'fkclient_id',
					  '-values'=>[$args{'client_id'},'any'],
					  '-size'=>50,
					  '-linebreak'=>'true',
					  '-default'=>"any",
					  '-override'=>1,
					  '-labels'=>\%client_labels);

    $widgets{'job_id'} = textfield('-name'=>'job_id',
				   '-default'=>'',
				   '-override'=>1,
				   '-size'=>5);

    $widgets{'bill_rate'} = textfield('-name'=>'bill_rate',
				      '-default'=>"",
				      '-override'=>1,
				      '-size'=>8);

    $widgets{'category'} = popup_menu('-name'=>'category',
				      '-default'=>'any',
				      '-override'=>1,
				      '-values'=>\@categories);
				      
				     

    $widgets{'open'} =  popup_menu('-name'=>'open',
				   '-values'=>['y','n','any'],
				   '-labels'=>\%yes_no_labels,
				   '-override'=>1,
				   '-default'=>'any');

    $widgets{'default_approved'} =   popup_menu('-name'=>'default_approved',
						'-values'=>['y','n','any'],
						'-default'=>'any',
						'-linebreak'=>'true',
						'-override'=>1,
						'-labels'=>\%yes_no_labels);


    $widgets{'fksupervisor_id'} =  popup_menu('-name'=>'fksupervisor_id',
					      '-values'=>\@supers,
					      '-override'=>1,
					      '-default'=>"$args{'remote_user'}");


    $widgets{'job_description'} = textfield('-name'=>'job_description',
					    '-default'=>"",
					    '-size'=>'55',
					    '-override'=>1,
					    '-maxlength'=>'55');

    $widgets{'output'} = popup_menu('-name'=>'output',
				    '-values'=>['long','short'],
				    '-default'=>'long',
				    '-override'=>1,
				    '-linebreak'=>'true');

    &subprint_file("$Conf::JOB_SEARCH_TMPL", \%widgets);

}


sub search_job {
    my %args = @_;
    my $sql;
    my $dbconn;
    my $oops;
    my $result;
    my $table;
    my $notfirst = 0;
    if ( ! $args{'remote_user'} ) {
	&error("remote_user not passed to search_job");
    }
    $table = "j_s_$args{'remote_user'}";
    $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
	$oops = $dbconn->errorstring;
	&error("Failed to perform search: $oops");
    }
    $dbconn->query("DROP TABLE $table;");
    $dbconn->query("create table $table (job_id int4);");
    $result = $dbconn->query("create index ${table}_idx on $table using btree (job_id int4_ops);");    
    $sql = "insert into $table select job_id ";
    $sql .= "FROM job ";
    if ( $args{'fkclient_id'} ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE fkclient_id = $args{'fkclient_id'} ";
	} else {
	    $sql .= "AND fkclient_id = $args{'fkclient_id'} ";
	}
    }
    
    if ( $args{'category'} ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE category = '$args{'category'}' ";
	} else {
	    $sql .= "AND category = '$args{'category'}' ";
	}
    }

    if ( $args{'fksupervisor_id'} ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE fksupervisor_id = '$args{'fksupervisor_id'}' ";
	} else {
	    $sql .= "AND fksupervisor_id = '$args{'fksupervisor_id'}' ";
	}
    }
    if ( $args{'job_id'} ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    unless($args{'job_id'} =~ /^\d+$/ ) {
		&error("Job ID is not valid");
	    }
	    $sql .= "WHERE job_id = $args{'job_id'} ";
	} else {
	    $sql .= "AND job_id = $args{'job_id'} ";
	}
    }

    if ( $args{'open'} eq "y" ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE open = 1 ";
	} else {
	    $sql .= "AND open = 1 ";
	}
    }
    if ( $args{'open'} eq "n" ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE open = 0 ";
	} else {
	    $sql .= "AND open = 0 ";
	}
    }
    if ( $args{'default_approved'} eq "y" ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE default_approved = 1 ";
	} else {
	    $sql .= "AND default_approved = 1 ";
	}
    }
    if ( $args{'default_approved'} eq "n" ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE default_approved = 0 ";
	} else {
	    $sql .= "AND default_approved = 0 ";
	}
    }
    if ( $args{'job_description'} ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE job_description ~* '$args{'job_description'}' ";
	} else {
	    $sql .= "AND job_description ~* '$args{'job_description'}' ";
	}
    }

    $sql .= ";";
    $result = $dbconn->query("$sql");
    if ( ! $result ) {
	$oops = $dbconn->errorstring;
	&error("Error doing search query: $oops", $sql);
    }

    return $table;
}

###############
# returns a indexed hash from the supplied temporary result table using 
# the supplied dbconn object.
#
# &get_job_search_result($dbconn, $table);
sub get_job_search_result {
    my $dbconn = shift;
    my $table = shift;
    my %results;
    my $i = 0;

    my @list = $dbconn->list('job_id',$table);

    while ($i <= $#list ) {
	my $tempjob_id = $list[$i];
	$i++;
	$results{$i} = $tempjob_id;
    }
    return %results;
}



sub admin_show_job_form {
    my %args = @_;

    my %yes_no_labels = ('y',' Yes','n',' No',); 
    my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        my $oops = $dbconn->errorstring;
        &error("Cannot connect to backend: $oops");
    }
    my @categories = $dbconn->list('category_id',$Conf::CATEGORY_DB,);
    $dbconn->close;
 
    #And Gawd said, "Let There be Widgets", and lo the widgets came
    
    my %widgets;
    
    $widgets{'heading'} = "<H3>JOB ID: $args{'job_id'} for $args{'job_client_name'}</H3>";


    $widgets{'category'} = popup_menu('-name'=>'category',
				      '-default'=>"$args{'category'}",
				      '-override'=>1,
				      '-values'=>\@categories);

    $widgets{'open_date'} = textfield('-name'=>'open_date',
				      '-default'=>"$args{'open_date'}",
				      '-size'=>10,
				      '-override'=>1,
				      '-maxlength'=>10);

    $widgets{'close_date'} = textfield('-name'=>'close_date',
				       '-default'=>"$args{'close_date'}",
				       '-size'=>10,
				       'override'=>1,
				       '-maxlength'=>10);
    
    $widgets{'bill_rate'} = textfield('-name'=>'bill_rate',
				      '-default'=>"$args{'bill_rate'}",
				      '-size'=>10,
				      '-override'=>1,
				      '-maxlength'=>10);

    $widgets{'flag_hrs'} = textfield('-name'=>'flag_hrs',
				      '-default'=>"$args{'flag_hrs'}",
				      '-size'=>4,
				      '-override'=>1,
				      '-maxlength'=>3);

    $widgets{'estimated_hours'} = textfield('-name'=>'estimated_hours',
					    '-default'=>"$args{'estimated_hours'}",
					    '-size'=>10,
					    '-override'=>1,
					    '-maxlength'=>10);
    
    $widgets{'current_estimate_date'} = textfield('-name'=>'current_estimate_date',
						  'default'=>"$args{'current_estimate_date'}",
						  '-size'=>9,
						  '-override'=>1,
						  '-maxlength'=>9);

    $widgets{'current_estimated_hours'} = $args{'current_estimated_hours'};
    
    $widgets{'open'} = popup_menu('-name'    => 'open',
				   '-values'  => ['y','n'],
				   '-default' => "$args{'open'}",
				   '-override'=>1,
				   '-labels'  => \%yes_no_labels);

    $widgets{'default_approved'} = popup_menu('-name'=>'default_approved',
					      '-values'=>['y','n'],
					      '-default'=>"$args{default_approved}", 
					      '-override'=>1,
					      '-labels'=>\%yes_no_labels);

    $widgets{'fksupervisor_id'} = popup_menu('-name'=>'fksupervisor_id',
					     '-values'=>$args{'supers'},
					     '-default'=>"$args{'fksupervisor_id'}",
					     'override'=>1);

    $widgets{'fknotify_id'} = scrolling_list('-name'=>'fknotify_id',
					     '-values'=>$args{'notifiers'},
					     '-default'=>"$args{'fknotify_id'}",
					     '-size'=>'3',
					     '-override'=>1,
					     '-multiple'=>'true');
    
    $widgets{'job_description'} = textfield('-name'=>'job_description',
					    '-default'=>"$args{'job_description'}",
					    '-size'=>55,
					    'override'=>1,
					    '-maxlength'=>55);

    &subprint_file("$Conf::JOB_EDIT_TMPL", \%widgets);
}  




sub job_join {
    my $dbconn = shift;
    my $job_entry = shift;
    
    my $sql = "SELECT JB.*, CL.client_name as job_client_name";
    $sql .= " FROM $Conf::JOB_DB JB, $Conf::CLIENT_DB CL WHERE ";
    $sql .= "JB.job_id = $job_entry AND CL.client_id = JB.fkclient_id;";

    my $sqlresult = $dbconn->query($sql);
    if ( ! $sqlresult ) {
	my $oops = $dbconn->errorstring;
	&error("Error getting job join for '$job_entry': $oops", $sql);
    }
    my %job_info = $sqlresult->get_row(0);
    return %job_info;
}



sub print_job_commands {
    my %state = @_;
    print "<TABLE BORDER=0>",
    "<tr valign=\"top\">\n";
    print "<TD>",
    "<INPUT TYPE=\"image\" NAME=\"apply\" SRC=\"images/apply.gif\" BORDER=0>\n",
    "</TD>";
    
    # Print seperator
    print "<TD><IMG SRC=\"images/star.gif\" BORDER=\"0\"></TD>\n";
    
    # Print delete button if it's not downloaded and
    # either we're a super, or we're user and it's not approved
    
    print "<TD>\n",
    "<INPUT TYPE=\"image\" NAME=\"delete\" SRC=\"images/delete.gif\" BORDER=0>\n",
    "</TD>\n";

    # Print seperator
    print "<TD><IMG SRC=\"images/star.gif\" BORDER=\"0\"></TD>\n";
    print "<TD>";
    print "<INPUT TYPE=\"image\" NAME=\"search\" SRC=\"images/search.gif\" BORDER=0>\n",
    "</TD></TR>\n",
    "</TABLE>\n";
}


1; 
 
