#
# help-content.pl
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: help-content.pl,v 1.5 2001/08/29 22:23:03 adam Exp $
#
# All help strings are in here for ease of maintainability.


###########################################################
###########################################################
# addnewclient strings
package Help;


%parents = (
	    'client_name'             => 'CLIENT_FUNCTIONS',
	    'client_default_approved' => 'CLIENT_FUNCTIONS',
	    'default_bill_rate'       => 'CLIENT_FUNCTIONS',
	    'username'                => 'USER_FUNCTIONS',
	    'userfullname'            => 'USER_FUNCTIONS',
	    'admin'                   => 'USER_FUNCTIONS',
	    'password'                => 'USER_FUNCTIONS',
);

$ti = "b";
$su = "strong";


###########

$MAIN_PAGE=<<EOT;

The <$su>Introduction to Timesheet</$su> page is the what you will see
whenever you enter the timesheet billing system. Navigate Timesheet's
functions using the button bar on the left, and if you ever get stuck,
just reach for the <$su>Help Button</$su>.

EOT

$CLIENT_FUNCTIONS=<<EOT;
The <$su>Client Functions</$su> page is the starting point for all client related actions:
<UL>
<LI>Add a New Client
<LI>Edit Client
<LI>Delete a Client
</UL>

<$ti>Add a New Client</$ti>
<P>

To <$su>Add a New Client</$su>, just fill in the fields on the
<$su>Client Functions</$su> page and press the <$su>Add a New
Client</$su> button located at the bottom of the page. Your client
will be added to the database and you will be returned to the
<$su>Client Functions</$su> page. The Client listing in the left frame
will also be updated at this time.

<P>
<$ti>Edit Client</$ti>
<P>

To <$su>Edit a Client</$su>, fill in <$su>Client Name</$su> and/or
<$su>Default Bill Rate</$su> with your search criteria and press the
<$su>Edit Client</$su> button. If only one client matches, you will be
presented with that client's record for modification. If there are
multiple matches, you will be presented with a list of all clients
that match your search criteria. I there are no matches, you will be
returned to this page in order to modify your search.

<P>
<$ti>Delete Client</$ti>
<P>

To <$su>Delete a Client</$su>, fill in <$su>Client Name</$su> and/or
<$su>Default Bill Rate</$su> with your search criteria and press the
<$su>Delete Client</$su> button. If only one client matches, you will
be requested to confirm that you wish to delete that client. If there
are multiple matches, you will be presented with a list of all clients
that match your search criteria. I there are no matches, you will be
returned to this page in order to modify your search.

EOT
#'

#####
$client_name=<<EOT;
<$ti>Client Name</$ti><P> 

The <$su>Client Name</$su> should be the Full Name of the client as it
will appear in the client listing that users choose from when logging
hours.

EOT


#####
$client_default_approved=<<EOT;
<$ti>Default Approved</$ti>
<P>

If this is set to yes, then <i>by default</i>, all jobs created for
this client will not require hours logged to be approved before
downloading. If set to no, all jobs created for this client
<i>will</i> require hours logged to be approved before downloading
into payroll.

<P> 

Note that this only changes the <i>default</i> presented to you when
you <$su>create new jobs</$su> for this client... you will still be
allow to set the <$su>Default Approved</$su> independently for each
job.

EOT


#####
$default_bill_rate=<<EOT;
<$ti>Default Bill Rate</$ti><P>

The <$su>Default Bill Rate</$su> should be a dollar amount which will
be used as the default (what else?) for all jobs created for this
client. You will still be able to set the <$su>Default Bill Rate</$su>
independently for each job. This field is required.

EOT

##########

$USER_FUNCTIONS=<<EOT;
The <$su>User Functions</$su> page is the starting point for all user related actions:
<UL>
<LI>Add a New User
<LI>Edit User
<LI>Delete a User
</UL>

<$ti>Add a New User</$ti>
<P>

To <$su>Add a New User</$su>, just fill in the fields on the <$su>User
Functions</$su> page and press the <$su>Add a New Client</$su> button
located at the bottom of the page. Your client will be added to the
database and you will be returned to the <$su>User Functions</$su>
page.

<P>
<$ti>Edit User</$ti>
<P>

To <$su>Edit a User</$su>, fill in <$su>User Name</$su>, <$su>First
Name</$su>, or <$su>Last Name</$su> with your search criteria and
press the <$su>Edit User</$su> button. If only one user matches, you
will be presented with that user's record for modification. If there
are multiple matches, you will be presented with a list of all users
that match your search criteria. I there are no matches, you will be
returned to this page in order to modify your search.

<P>
<$ti>Delete user</$ti>
<P>

To <$su>Delete a user</$su>, fill in <$su>User Name</$su>, <$su>First
Name</$su>, or <$su>Last Name</$su> with your search criteria and
press the <$su>Delete User</$su> button. If only one user matches, you
will be presented with that user's record for modification. If there
are multiple matches, you will be presented with a list of all users
that match your search criteria. I there are no matches, you will be
returned to this page in order to modify your search.

EOT


#####
$username=<<EOT;
<$ti>User Name</$ti><P>

The <$su>User Name</$su> should be one word (often the login name of
the user) that the user will use to log all hours.

EOT


#####
$user_email=<<EOT;
<$ti>User Email Address</$ti><P>

This email address should be a valid address to reach the user in
<i>user\@domain</i> format.

EOT

#####
$userfullname=<<EOT;
<$ti>First, Middle, and Last Name</$ti><P>

The <$su>First and Last Name</$su> are required, the <$su>Middle Name
(or Initial)</$su> is optional.

EOT

#####
$admin=<<EOT;
<$ti>Administrator</$ti><P>

The <$su>Administrator</$su> option will give this user read/write
access privileges to the entire timesheet system. Recommended only for
Managers.

EOT

#####
$password=<<EOT;
<$ti>Password</$ti><P>

The <$su>Password</$su> should be at least 6 characters long and
contain at least one non-alphanumeric character. Remember to make a
smart password! Please enter password twice to make sure that you have
not made a mistake.

EOT



