#!/usr/bin/perl
#
# dump-clients-jobs.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# Made a cgi by Mike Welles (mike@onshore.com) 3/99
#
# Originally dump-clients-jobs.pl By Brian Fitzpatrick (fitz@onShore.com)
# 06/15/98
#
# Exports all clients, and all open jobs into 2 files in 
# webspace that can (and will) be grabbed by timesheet.el
#
#
#use strict qw(refs vars);

require 'lib/common-funcs.pl';
require 'etc/timesheet.conf';
use CGI qw(:standard);
#use Timesheet;
use ADB;

my $sep = "::";
my $debug = 0;

$n=new CGI; 
my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
if(!$dbconn->is_ok){
   my $oops = $dbconn->errorstring;
   &error("Cannot Connect to backend: $oops\n");
}

print $n->header(-type=>'text/plain'); 
if ( $n->param(-name=>'dump') eq "client" ) { 
  &print_client_list();
  print "$clientfile Done!\n" if $debug;
}
elsif ( $n->param(-name=>'dump') eq "job" ) { 
  print "Printing Job List...\n" if $debug;
  &print_job_list();
}

print "$jobfile Done!\n" if $debug;
$dbconn->close;

###########################################################
###########################################################
sub print_client_list {
    my $result = $dbconn->query("Select client_id, client_name from $Conf::CLIENT_DB");
   
   if (!$result) {
       my $oops = $dbconn->errorstring;
      &error("Error add_client_entry Selecting records: $oops\n");
   }
   my $rows = $result->get_num_rows;
   if (!$rows) {
      &error("No Clients matched your query\n");
   }
 
   my $i = 0;
   my ($id,$name);
   while ($i < $rows){
      $id = $result->get_value($i, 'client_id');
      $name = $result->get_value($i, 'client_name');
      print "$id$sep$name\n";
      $i++;
   }
}


sub print_job_list {
   my $result = $dbconn->query("Select job_id, job_description, fkclient_id from $Conf::JOB_DB where open = 1");
   
   if (!$result){
      my $oops = $dbconn->errorstring;
      &error("Error add_job_entry Selecting records: $oops\n");
   }
   my $rows = $result->get_num_rows;
   if (!$rows) {
      &error("No Jobs matched your query\n");
   }
 
   my $i = 0;
   my ($id,$name,$client);
   while ($i < $rows){
      $id = $result->get_value($i, 'job_id');
      $name = $result->get_value($i, 'job_description');
      $client = $result->get_value($i, 'fkclient_id');
      # $open = $result->get_value($i, 'open');
      # print "OPEN $open\n";
      print "$id$sep$name$sep$client\n";
      $i++;
   }
   close(JOB);
}
