#!/usr/bin/perl
#
# downloadjobs.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: downloadjobs.cgi,v 1.8 2001/08/29 22:22:45 adam Exp $
# 
##use strict qw(refs vars);
use CGI qw(:standard);
require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';
use ADB;

my %state;
my $dbconn;
my $reply;
my $oops;


print "Content-type:application/x-onshore-jobs\n\n";
$dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
   if(!$dbconn->is_ok){
		$oops = $dbconn->errorstring;
      &error("Cannot connect to backend: $oops");
   }


my $sql = "SELECT * from job WHERE downloaded='n' ORDER BY job_id";
    
    $reply = $dbconn->query($sql);
if(!$reply){
    $oops = $dbconn->errorstring;
    &error("Error getting your jobs: $oops", $sql);
}
my $numrows = $reply->get_num_rows;
my %row;  
my @hrs;   
my $i = 0;
&print_heading;

while($i < $numrows){
    %row = $reply->get_row($i);
    &print_row(%row);
    push @jobs, $row{'job_id'};
    $i++;
}

sub print_row{
    my %rec = @_;
    my $var;
    my $first;
    $first = 0;
# Untabbify 
    my @variables = ('job_id','fkclient_id','fksupervisor_id',
		     'estimated_hours', 'category',
		     'open_date', 'bill_rate','job_description');
    foreach $var (@variables){
      $rec{$var} =~ s/\t/    /g;
      $rec{$var} =~ s/\r/ /g;
      $rec{$var} =~ s/\n/ /g;
      $rec{$var} =~ s/\f/ /g;
      if ($first == 0){
	$first = 1;
	print "$rec{$var}";
      }else{
	print "\t$rec{$var}";
      }
    } 
    print "\r";
    $dbconn->query("UPDATE job SET downloaded = 'y' WHERE job_id = $rec{'job_id'};");
  }

sub print_heading{
    my $first;
    my $var;
    my @variables = ('job_id','fkclient_id','fksupervisor_id',
		     'estimated_hours','category',
		     'open_date', 'bill_rate','job_description');
    $first = 0;
    foreach $var (@variables){
	$var =~ s/\t/    /g;
    $var =~ s/\r/ /g;
    $var =~ s/\n/ /g;
    $var =~ s/\f/ /g;
	if ($first == 0){
            $first = 1;
            print "$var";
        }else{
            print "\t$var";
        }
    }
    print "\r";
}

    

