#!/usr/local/bin/perl
#
# integrity.pl
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: integrity.pl,v 1.6 2001/08/29 22:22:52 adam Exp $
#  
use ADB;
require "../etc/timesheet.conf";
$dbconn = new ADB(localhost,$Conf::SQLDB);
if(!$dbconn->is_ok){
    my $err = $dbconn->errorstring;
    die "Error getting backend connection: $err\n";
}

my $result;
my $sql;

&hours_to_job;
&job_to_client;

#Hours -> Job Integrity
sub hours_to_job {
    print "Performing $Conf::HOURS_DB.fkjob_id -> $Conf::JOB_DB.job_id Reference Integrity Check:\n";
    $result = $dbconn->query("SELECT hours_id, fkjob_id from $Conf::HOURS_DB WHERE downloaded = 'n';");
    if (!$result){
	my $err = $dbconn->errorstring;
	print "Error executing SQL: $err\n";
	return 0;
    }
    my $it = 0;
    my $numrows = $result->get_num_rows;
    while ($it < $numrows){
	my $job_req = 0;
	my $curr_hours_id = $result->get_value($it, "hours_id");
	my $curr_job_id = $result->get_value($it, "fkjob_id");
	$job_req = $dbconn->query("SELECT job_id from $Conf::JOB_DB WHERE job_id = $curr_job_id;");
	if(!$job_req || !$job_req->get_num_rows){
	    print "Referential Failure: Hours: $curr_hours_id\tJob:$curr_job_id\n";
	    $it++;
	    next;
	}
	if($curr_job_id != $job_req->get_value(0, "job_id")){
	    print "Referential Failure: Hours: $curr_hours_id\tJob: $curr_job_id\n";
	}
	$it++;
    }
}

sub job_to_client {
    print "Performing $Conf::JOB_DB.fkclient_id -> $Conf::CLIENT_DB.client_id Reference Integrity Check\n";
    $result = $dbconn->query("SELECT * from $Conf::JOB_DB;");
    if (!$result){
	my $err = $dbconn->errorstring;
	print "Error executing SQL: $err\n\n";
	return 0;
    }
    my $it = 0;
    my $numrows = $result->get_num_rows;
    while ($it < $numrows){
	my $client_req = 0;
	my $curr_job_id = $result->get_value($it, "job_id");
	my $curr_job_desc = $result->get_value($it, "job_description");
	my $curr_man = $result->get_value($it, "fksupervisor_id");
	my $curr_open_date = $result->get_value($it, "open-date");
	my $curr_client_id = $result->get_value($it, "fkclient_id");
	if (!$curr_client_id){
	    print "Referential Failure: Job: $curr_job_id\t Manager: $curr_man\n
			   Description: $curr_job_desc\t OpenDate: $cur_open_date\t
			   ClientId wante: $curr_client_id\n\n";
	    $it++;
	    next;
	}
	$client_req = $dbconn->query("SELECT client_id from $Conf::CLIENT_DB WHERE client_id = $curr_client_id;");
	if(!$client_req || !$client_req->get_num_rows){
	    print "Referential Failure: Job: $curr_job_id\tTo: $curr_client_id\n";
	    $it++;
	    next;
	}
	if ($curr_client_id != $client_req->get_value(0, "client_id")){
	    print "Referential Failure: Job: $curr_job_id\tTo: $curr_client_id\n";
	    $it++;
	    next;
	}
	$it++;
    }
}

