#!/usr/bin/perl
#
# button-bar.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# 

require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';
use CGI qw(:standard);
use ADB;

print header;

my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
if ( !$dbconn->is_ok ) {
    my $oops = $dbconn->errorstring;
    &error("Cannot connect to backend: $oops\n");
}

my $remote_user = remote_user;

if (!$remote_user) {
    &error("Cannot determine what user you are, make sure that password authentication is enabled for this page.");
}

my $clientrec = $dbconn->get_record($Conf::USER_DB_KEY, $remote_user,
				    $Conf::USER_DB);
if (!$clientrec) {
    my $oops = $dbconn->errorstring;
    &error("Unable to get user name \"$remote_user\" from column \"$Conf::USER_DB_KEY\", in table \"$Conf::USER_DB\": $oops\n");
}

my $user_name = $$clientrec{'first_name'} . " " . $$clientrec{'last_name'};

my $dead = '';

my $log_script = $Conf::HTTP_DIR . "loghours.cgi";

my $javascript=<<EOT;

currenticon='';
currenticonnum=-1;
reverticon='';
got_client = '';
reverted = '';

function change(righturl, iconnum, hilitedicon, revicon, wantclient) {
    reverted = hilitedicon;

    if (currenticonnum != -1) {
	if (navigator.appVersion.substring(0,1)=='3' &&
	    navigator.appName=='Netscape')  {
	    if (reverted != currenticon) {
		document.images[currenticonnum].src=reverticon;
		window.status=reverticon;
	    }
	}
    }

   if (wantclient) {
       if (got_client == 'true') {
	   parent.frames[0].document.forms[0].action = righturl;
	   document.bar.submit();

	   currenticon=hilitedicon;
	   currenticonnum=iconnum;
	   reverticon=revicon;
       }
       else {
	   alert('Error: You need to choose a client first!');
       }
   }
    else {
	parent.frames[0].document.forms[0].action = righturl;
	document.bar.submit();
	
	currenticon=hilitedicon;
	currenticonnum=iconnum;
	reverticon=revicon;
    }
}

function swap(imageno, whichimage) {
    if (((navigator.appVersion.substring(0,1)=='3')||(navigator.appVersion.substring(0,1)=='5')) && navigator.appName=='Netscape')
    {
	if (currenticonnum != imageno) {
	    document.images[imageno].src=whichimage;
	}
    }
}

function do_log() {
    if (top.frames[1].location == "$log_script") {
//      optionselected=parent.left.document.bar.client_name.selectedIndex;
//      alert(parent.left.document.bar.client_name.options[optionselected].value)
	document.bar.action = "loghours.cgi";
	document.bar.submit();
    }
//   else {
//      parent.right.location.reload()
//      document.bar.submit();
//   } 
    got_client = 'true';
}


EOT

print start_html(-'title'=>$Conf::ORG,
		 -BACKGROUND => $Conf::BACKGROUND, 
		 -'script'=>$javascript,
		 -BGCOLOR => 'ababab');

print <<EOT;

<NOSCRIPT> 
<b>
This application requires JavaScript enabled on your browser, yet 
it appears that you do not have it turned on. Please enable JavaScript 
and reload this page (if you are using Internet Explorer you need to 
enable "Active Scripting").
</b>
</NOSCRIPT>

<FORM NAME=bar METHOD="POST" TARGET="right">

<a href="welcome.cgi" TARGET="right"
OnMouseOver="window.status= 'Return to the main Timesheet screen';return true" 
OnMouseOut="window.status= '';return true">
<IMG SRC="images/tinylogo.gif" BORDER="0"></a>
<br>
<STRONG>$user_name</STRONG>
<br>
<FONT SIZE=-1>
EOT

&print_client_list('multiples'=>0);

if ($remote_user eq "$Conf::DOWNLOAD_USER") {
    &make_choice_download;
} elsif (&is_superuser(remote_user)) {
    &make_choice_admin;
} else {
    &make_choice_user;
}
    
print <<EOT;
</body>
</html>
EOT


###########################################################
###########################################################
sub make_choice_admin {

    print <<EOT;
<P>


<a href="JavaScript:change('loghours.cgi', 1, 'images/loghours.gif', 'images/loghours1.gif',1)">
<img src="images/loghours1.gif" border=0 alt="Log Hours"></a>
<BR>



<a href="JavaScript:change('choose.cgi', 2, 'images/reports.gif', 'images/reports1.gif')">
<img src="images/reports1.gif" border=0 alt="Generate a report"></a>
<BR>



<a href="JavaScript:change('viewedithours.cgi', 3, 'images/viewedithours.gif', 'images/viewedithours1.gif',0)">
<img src="images/viewedithours1.gif" border=0 alt="View/Edit Hours"></a>
<BR>



<a href="JavaScript:change('addnewjob.cgi', 4, 'images/addnewjob.gif', 'images/addnewjob1.gif',1)">
<img src="images/addnewjob1.gif" border=0 alt="Add a new Job"></a>
<BR>


<a href="JavaScript:change('vieweditjobs.cgi', 5, 'images/vieweditjobs.gif', 'images/vieweditjobs1.gif',1)">
<img src="images/vieweditjobs1.gif" border=0 alt="View/Edit Jobs"></a>
<BR>


<a href="JavaScript:change('downloadhours.cgi',6, 'images/downloadhours.gif', 'images/downloadhours1.gif')">
<img src="images/downloadhours1.gif" border=0 alt="Download Hours"></a>
<BR>


<a href="JavaScript:change('addnewclient.cgi', 7, 'images/addnewclient.gif', 'images/addnewclient1.gif')">
<img src="images/addnewclient1.gif" border=0 alt="Add a New Client"></a>
<BR>

<a href="JavaScript:change('vieweditclients.cgi', 8, 'images/vieweditclient.gif', 'images/vieweditclient1.gif')">
<img src="images/vieweditclient1.gif" border=0 alt="View/Edit a Client"></a>
<BR>


<a href="JavaScript:change('addnewuser.cgi', 9,'images/addnewuser.gif', 'images/addnewuser1.gif')">
<img src="images/addnewuser1.gif" border=0 alt="Add a New User"></a>
<BR>


<a href="JavaScript:change('vieweditusers.cgi', 10,'images/viewedituser.gif', 'images/viewedituser1.gif')">
<img src="images/viewedituser1.gif" border=0 alt="View/Edit a User"></a>
<BR>
<p>
<A HREF="$Conf::BUG_REPORT_URL" TARGET="_blank">Report a Bug</A>
<p>


EOT

}



###########################################################
###########################################################
sub make_choice_user {
    print <<EOT;
<P>

<a href="JavaScript:change('loghours.cgi', 1, 'images/loghours.gif', 'images/loghours1.gif',1)">
<img src="images/loghours1.gif" border=0 alt="Log Hours"></a>
<BR>

<a href="JavaScript:change('viewedithours.cgi', 2, 'images/viewedithours.gif', 'images/viewedithours1.gif',1)">
<img src="images/viewedithours1.gif" border=0 alt="View / Edit Hours"></a>
<BR>


<a href="JavaScript:change('downloadhours.cgi', 3, 'images/downloadhours.gif', 'images/downloadhours1.gif')">
<img src="images/downloadhours1.gif" border=0 alt="Download Hours"></a>
<BR>
<p>
<A HREF="http://bugs.onshore.com/gnats-Timesheet/$remote_user/$remote_user\@onshore.com/send_pr" TARGET="_blank">Report a Bug</A>
</p>

EOT

}

### prints the button bar for the download user
sub make_choice_download {

    print <<EOT;
<P>

<a href="JavaScript:change('downloadjobs.cgi', 1, 'images/downloadjobs1.gif', 'images/downloadjobs1.gif')">
<img src="images/downloadjobs.gif" border=0 alt="Download Jobs"></a>
<BR>


<a href="JavaScript:change('downloadhours.cgi', 2, 'images/downloadhours.gif', 'images/downloadhours1.gif')">
<img src="images/downloadhours1.gif" border=0 alt="Download Hours"></a>
<BR>
<p>
<A HREF="http://bugs.onshore.com/gnats-Timesheet/$remote_user/$remote_user\@onshore.com/send_pr" TARGET="_blank">Report a Bug</A>
<p>

EOT

}




###########################################################
###########################################################
sub print_client_list {
    my %params = @_;
    my @clients = ();
    my $count_cli = 0;
    my %clientlabels = ();
    
    my $result = $dbconn->query("Select client_id, client_name from $Conf::CLIENT_DB");
    
    if (!$result) {
	my $oops = $dbconn->errorstring;
	&error("Error in add_client_entry selecting records: $oops\n");
   }
    my $rows = $result->get_num_rows;
    if (!$rows) {
	&error("There are no clients in table \"$Conf::CLIENT_DB\".\n");
    }
    print "<INPUT TYPE=\"hidden\" NAME=\"list\" VALUE=\"1\">\n";	

    my $i = 0;
    my $id;
    my $lab;
    my %labels;
    my %alph;
    my $tmptmp;
    my @names;
    while ($i < $rows) {
	$id = $result->get_value($i, 'client_id');
	$lab = "";
      
	$tmptmp = $result->get_value($i, 'client_name');
	$lab .= $tmptmp;
	$labels{$id} = $lab;
	$alph{$tmptmp} = $id;
	$i++;
    }
    # tell me there is a better way to sort a hash by value
    my @alpharr = sort { uc($a) cmp uc($b)} values %labels; 
    my $item;
    foreach $item (@alpharr) {
	push @names, $alph{$item};
    }
 
    my $label = '';
    foreach $label (keys %labels) {
	$labels{$label} = substr $labels{$label},0,21;
	if (length($labels{$label}) == 21) {
	    substr($labels{$label}, -3, 3) = '...'; 
	}
    }

    my $size_of_box = @names;
    $size_of_box = &get_box_size($size_of_box);
    if ($size_of_box >= 8 ) {
	$size_of_box = 8;
    }

    print scrolling_list('-name'=>'client_id',
			 '-values'=>\@names,
			 '-default'=>"",
			 '-size'=>$size_of_box,
			 '-multiple'=>'',
			 '-onChange'=>'do_log()',
			 '-labels'=>\%labels);

}

$dbconn->close;
