#!/usr/bin/perl
#
# addnewjob.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# 

require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';
use CGI qw(:standard);
use ADB;


my $function = param('function');
my $client = param('client_id');
&time_head($Conf::ADD_JOB);
&help_button_big('ADD_JOB');

########################################################
if (!param) {
				# FIXME: huh?
}
elsif ($function eq "create") {
   
    print <<EOT;
<CENTER>
<IMG SRC="images/addnewjob-big.gif" BORDER=0 ALT=[Add New Job]>
</CENTER>
<FORM NAME=addnewjob METHOD="POST" ACTION="addnewjob.cgi" TARGET="right">
<INPUT TYPE="hidden" NAME="client_id" VALUE="$client">
<INPUT TYPE="hidden" NAME="function" VALUE="create">
EOT
    $remote_user = remote_user;
    &add_job_submit;
    &reset_all_params();
    &print_job_form;
}
else {
    print <<EOT;
<CENTER>
<IMG SRC="images/addnewjob-big.gif" BORDER=0 ALT=[Add New Job]>

</CENTER>
<FORM NAME=addnewjob METHOD="POST" ACTION="addnewjob.cgi" TARGET="right">
<INPUT TYPE="hidden" NAME="client_id" VALUE="$client">
<INPUT TYPE="hidden" NAME="function" VALUE="create">
EOT
    $remote_user = remote_user;
    &print_job_form;
}




#######################################################
#######################################################
################## Subroutines ########################
#######################################################
#######################################################

sub reset_all_params {
    param('open_date'             ,&date_today);
    param('close_date'            ,'');
    param('flag_hrs'				 ,'');
    param('bill_rate'             ,'');
    param('estimated_hours',      ,'');
    param('current_estimate_date' ,'');
    param('open'                  ,'');
    param('default_approved'      ,'n');
    param('fksupervisor_id'       ,"$remote_user");
    param('fknotify_id'           ,'');
    param('job_description'       ,'');

}

sub print_job_form {
    if (!param('client_id')) {
	&error(li("You must choose a client for the job number!"));
    }
    my $client_id = param('client_id');

    my %yes_no_labels = ('y',' yes','n',' no',);      
    my @super = ();
    my @notify = ();

    my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if(!$dbconn->is_ok){
	my $oops = $dbconn->errorstring;
	&error("Cannot connect to backend: $oops\n");
    }
    my @categories = $dbconn->list('category_id',$Conf::CATEGORY_DB,);
    my @notifiers =  $dbconn->list('personnel_id',$Conf::USER_DB,);
    my @supers = $dbconn->list('personnel_id',$Conf::USER_DB,"super_user = '1'");

    # get client_name form client_id
    my $client_rec = $dbconn->get_record($Conf::CLIENT_DB_KEY, $client_id,
					 $Conf::CLIENT_DB);	
    if(!$client_rec){
	my $oops = $dbconn->errorstring;
	&error("Unable to get client name for $client_id: $oops");
    }
    my $client = $$client_rec{'client_name'};
    my $default_bill = $$client_rec{'default_bill_rate'};
    $dbconn->close;

    # hi ho hi ho off to widgets we go
    my %widgets;

    $widgets{'heading'} = "Adding a New Job Number for Client $client";
   
    $widgets{'open_date'} = textfield('-name'=>'open_date',
				      '-default'=>&date_today,
				      '-size'=>10,
				      '-maxlength'=>10);

    $widgets{'close_date'} = textfield('-name'=>'close_date',
				       '-default'=>"",
				       '-size'=>10,
				       '-maxlength'=>10);

    $widgets{'bill_rate'} = textfield('-name'=>'bill_rate',
				      '-default'=>"$default_bill",
				      '-size'=>10,
				      '-override'=>'1',
				      '-maxlength'=>10);

    $widgets{'estimated_hours'} = textfield('-name'=>'estimated_hours',
					    '-default'=>'',
					    '-size'=>10,
					    '-maxlength'=>10);

    $widgets{'current_estimate_date'} = textfield('-name'=>'current_estimate_date',
						  '-default'=>"",
						  '-size'=>10,
						  '-maxlength'=>10);

    $widgets{'flag_hrs'} = textfield('-name'=>'flag_hrs',
				     '-default'=>"",
				     '-size'=>4,
				     '-maxlength'=>4);

    $widgets{'open'} = popup_menu('-name'    => 'open',
				  '-values'  => ['y','n'],
				  '-default' => 'y',
				  '-labels'  => \%yes_no_labels);
    
    $widgets{'default_approved'} = popup_menu('-name'=>'default_approved',
					      '-values'=>['y','n'],
					      '-default'=>'n',
					      '-override'=>1,
					      '-labels'=>\%yes_no_labels);

    $widgets{'fksupervisor_id'} = popup_menu('-name'=>'fksupervisor_id',
					     '-values'=>\@supers,
					     '-default'=>"$remote_user"),

    $widgets{'fknotify_id'} = scrolling_list('-name'=>'fknotify_id',
					     '-values'=>\@notifiers,
					     '-default'=>'',
					     '-size'=>'3',
					     '-multiple'=>'true'),

    $widgets{'job_description'} = textfield('-name'=>'job_description',
					    '-default'=>"",
					    '-size'=>55,
					    '-maxlength'=>55);

    $widgets{'category'} = popup_menu('-name'=>'category',
				      '-values'=>\@categories);

    $widgets{'submit'} = '<INPUT NAME="create" TYPE="image" SRC="images/createnewjob.gif" ALT="[Create New Job]" BORDER=0>';

    &subprint_file("$Conf::JOB_ADD_TMPL", \%widgets);
}


sub add_job_submit{
    my %new;
    my @notify; 
    $new{'fkclient_id'} = param('client_id');
    $new{'open_date'} = param('open_date');
    $new{'close_date'} = param('close_date');
    $new{'job_description'} = param('job_description');
    $new{'bill_rate'} = param('bill_rate');
    $new{'fksupervisor_id'} = param('fksupervisor_id');
    my @notify=param('fknotify_id');
    $new{'fknotify_id'} = &comma_pack_vals(@notify); 
    $new{'estimated_hours'} = param('estimated_hours');
    $new{'current_estimate_date'} = param('current_estimate_date');
    $new{'flag_hrs'} = param('flag_hrs');
    $new{'category'} = param('category');
    $new{'downloaded'} = 'n';
    
    my $open_tmp = param('open');
    my $default_approved_tmp = param('default_approved');
    my $error = '';
    $new{'open'} = 0;
    $new{'default_approved'} = 0;
    if ($new{'open_date'} eq ''){
	$error .= "Must provide an Open Date\n";
    }
   
    if ($new{'category'} eq 'None'){
	$error .= "Category cannot be set to `None'\n";
    }

    if ($new{'bill_rate'} eq ''){
	$error .= "Must provide a Bill Rate\n";
    }
   
    $new{'open_date'} = &dbdate($new{'open_date'});
    if ($new{'close_date'}){
	$new{'close_date'} = &dbdate($new{'close_date'});
    } else {
	# FIXME: should be parameterized
	$new{'close_date'} = '12-31-9999';
    }
    if ($new{'current_estimate_date'}){
	$new{'current_estimate_date'} = &dbdate($new{'current_estimate_date'});
    } else {
	# FIXME: should be parameterized
	$new{'current_estimate_date'} = '12-31-9999';
    }
    if (!$new{'open_date'}){
	$error .= "Open Date not in correct format, must be MM/DD/YY\n";
    }
   
    if($error) {
	&error($error);
    }
    if ($open_tmp eq "y"){
	$new{'open'} = 1;
    }
    if ($default_approved_tmp eq "y"){
	$new{'default_approved'} = 1;
    }

    # escape it for the SQL
    &scrub_hash(\%new);
   
    my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    my $result;
    $result = $dbconn->insert_record_seq($Conf::JOB_DB_KEY, $Conf::JOB_DB, \%new);
    if (!$result) {
	my $oops = $dbconn->errorstring;
	&error("Unable to add job to backend: $oops\n");
    }
    print "<HR SIZE=3><H2>Job Successfully Added, your Job Number is $result</H2><HR SIZE=3>";
    return;
}

