%erect ( epsFile , x , y , width , height , lineWidth, color, dash)
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function erect(epsFile,x,y,width,height,lineWidth,color,dash)
  if (nargin~=8)
    usage ('erect ( epsFile, x, y, width, height, lineWidth, color, dash)');
  end

  if dash>0
    fprintf(epsFile,'[%1.2f %1.2f] 0 setdash\n',dash,dash);
  end
  fprintf(epsFile,'currentrgbcolor %1.2f %1.2f %1.2f setrgbcolor\n',...
                   color(1),color(2),color(3));
  fprintf(epsFile,'newpath\n');
  fprintf(epsFile,'%1.2f %1.2f moveto\n',x,y);
  fprintf(epsFile,'%1.2f %1.2f rlineto\n',width,0);
  fprintf(epsFile,'%1.2f %1.2f rlineto\n',0,height);
  fprintf(epsFile,'%1.2f %1.2f rlineto\n',-width,0);
  fprintf(epsFile,'%1.2f %1.2f rlineto\n',0,-height);
  fprintf(epsFile,'closepath\n');
  fprintf(epsFile,'%1.2f setlinewidth\n',lineWidth);
  if dash<0
    fprintf(epsFile,'fill\n');
  else
    fprintf(epsFile,'stroke\n');
  end
  fprintf(epsFile,'setrgbcolor\n');
  if dash>0
    fprintf(epsFile,'[] 0 setdash\n');
  end
