%%NAME
%%  eppmwrit  - save image as PPM-file 
%%
%%SYNOPSIS
%%  eppmwrit(filename,image,colormap[,binary])
%%
%%PARAMETER(S)
%%  filename    name of PPM-file
%%  image       image matrix 
%%  colormap    color table 
%%  binary      default: binary=1 for binary PPM-file 
%%              binary=0 for ascii PPM-file
%% 
% written by Stefan Mueller stefan.mueller@fgan.de 2001
function eppmwrit (filename,image,colormap,binary)
  if (nargin<3) | (nargin>4)
    usage('eppmwrit(filename,image[,colormap])');
  end
% image matrix and colormap -> rgb-map
  if nargin==3 
    binary=1;
  end
  imgSize=size(image);
  maxValue=255; 
  colormap=colormap'*maxValue;
  image=reshape(image',1,imgSize(1)*imgSize(2));
  data=colormap(:,image);
  data=reshape(data,1,imgSize(1)*imgSize(2)*3);

% write ppm-file
  ppmFile=fopen(filename ,'w');
  if binary
    fprintf(ppmFile,'P6\n');
  else
    fprintf(ppmFile,'P3\n');
  end
  fprintf(ppmFile,...
    '# Image generated %s by epsTk 1.9 (stefan.mueller@fgan.de)\n',date);
  fprintf(ppmFile,'%d %d\n',imgSize(2),imgSize(1));
  fprintf(ppmFile,'%d\n',maxValue);

  if binary
    n=fwrite(ppmFile,data,'uchar');
  else
    n=fprintf(ppmFile,'%d ',data);
  end
  fclose(ppmFile);
