/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** TRANSACT.C - This is the ODBC driver code for processing transactions.
**
*/


#include "myodbc.h"

//	SQLC transaction control functions.

SQLRETURN SQL_API SQLTransact(SQLHENV henv,SQLHDBC hdbc,SQLUSMALLINT fType)
{
  DBC FAR *dbc=(DBC FAR*) hdbc;
  SQLRETURN result=SQL_SUCCESS;
  DBUG_ENTER("SQLTransact");
  DBUG_PRINT("enter",("fType: %d",fType));

  if (dbc && !(dbc->flag & FLAG_NO_TRANSACTIONS))
  {
    const char *query;
    if (!(dbc->mysql.server_capabilities & CLIENT_TRANSACTIONS))
    {
      if (fType == SQL_ROLLBACK)
      {
        set_dbc_error(dbc,
	             "S1C00",
	             "The used MySQL server doesn't support transactions",
	             4000);
        result=SQL_ERROR;
      }
      goto end;
    }
    query= (fType == SQL_COMMIT) ? "COMMIT" : "ROLLBACK";
    pthread_mutex_lock(&dbc->lock);
    if (check_if_server_is_alive(dbc) ||
	      mysql_real_query(&dbc->mysql,query,strlen(query)))
    {
      set_dbc_error(dbc,"S1000",
		    mysql_error(&dbc->mysql),
		    mysql_errno(&dbc->mysql));
      result=SQL_ERROR;
    }
    pthread_mutex_unlock(&dbc->lock);
  }
end:
  DBUG_RETURN(result);
}
