/***************************************************************************
                          gnudownload.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#if !defined(__GNUDOWNLOAD_H_INCLUDED__)
#define __GNUDOWNLOAD_H_INCLUDED__

/////////////////////////////////////////////////////////////////////////////
// MGnuDownload

class MGnuDirector;
class MGnuNode;
class MGnuPreferences;
class MGnuSearch;
class MAsyncFile;

struct SGnuDownload
{
	// Download Properties
	CString m_sName;
	CString m_sFilePath;
	CString m_sPartialPath;
	CString m_sSearch;
	DWORD   m_dwSearchID;
	//
	CString m_sHeader;
	// File info
	DWORD   m_dwFileLength;
	DWORD   m_dwBytesCompleted;
	// source addresses, etc
	std::vector<Result> m_Queue;
	int m_nQueuePos;
	// Bandwidth
	double m_dRate;          // real download rate in bytes per second
	//
	bool   m_bActive;
	int    m_nSecInactive;	
	// status
	int    m_nDisconnectReason;
	int    m_nStatus;
	// ID for UI
	DWORD  m_dwID;
	// few static methods
	static LPCSTR GetErrorString(int nCode);
	static LPCSTR GetStatusString(int nStatus);
};

class MGnuDownload : public MAsyncSocket, public SGnuDownload
{
public:
	MGnuDownload(MGnuDirector*);
	virtual ~MGnuDownload();

	void StartDownload(bool bLock);
	void StopDownload(bool bDeleteFile, bool bLock);

	void CheckFile(); // set all the paths and check if there is a partial file
	void OpenFile(); // open the file and get ready
	void CloseFile();
	
	void SendRequest();
	void Download(BYTE*, int);

	void NextInQueue();
	void UpdateResults();
	void AddSearch(bool bAutoget);

	void ForceDisconnect(int nReason);
	void StatusUpdate(DWORD);
	bool IsActive();
	
	void BandwidthTimer();
	
	IP GetCurrentHost();
	int GetCurrentPort();
	
// Overrides
public:
	virtual void OnConnect(int nErrorCode);
	virtual void OnReceive(int nErrorCode);
	virtual void OnClose(int nErrorCode);
	
	// async write notifier
	void OnFileWritten(int nRequested, int nWritten, int nError);
	void OnFileOpen(bool bLock = true);
	void OnFileRead(int nRequested, int nRead, int nError);
	void OnFileError(int nError);
	void OnFileClose();
protected:
	void BlockOnReceive(bool bBlock);
	bool m_bReceiveBlocked;
public:
	MMutex m_mutex;
	bool m_bDeleteSearch;
protected:
	MGnuDownload();                          // no implementation
	MGnuDownload(const MGnuDownload& rSrc);  // no implementation
	
// Implementation
protected:
	std::vector<Result> m_BadResults;
	// Bandwidth calculation
	DWORD  m_dwBytes60;     // Bytes received in last 60 seconds
	DWORD  m_dwSecBytes;    // Bytes sent in last second
	DWORD  m_dwAvgBytes[60]; // Average bytes from last 60 seconds
	int    m_nSecPos;        // Position of next element insert for m_dwAvgBytes
	// various timers
	int    m_nSecCounter;   // Number of seconds since last status change
	int    m_nSecsUnderLimit;
	int    m_nSecsDead;
	int    m_nWaitDelay; // delay counter for e,g, push, etc
	// file
	MAsyncFile* m_pAFile;
	// buffer
	BYTE* m_pBuffer;
	int   m_nBuffSize;
	int   m_nAvgBytesAvailable;
	BYTE* m_pDataToWriteOnOpen;
	int   m_nSizeToWriteOnOpen;
	// Resume Verification
	int   m_nVerifyPos;
	BYTE  m_Verification[4096];
	DWORD m_dwResumeStart;
	//
	MGnuPreferences* m_pPrefs;
	MGnuDirector*  m_pDirector;
};

/////////////////////////////////////////////////////////////////////////////

#endif // __GNUDOWNLOAD_H_INCLUDED__

