/***************************************************************************
                          common.cpp  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "mutella.h"

time_t xtime()
{
	MLock lock(g_LibcMutex);
	return time(NULL);
}

// generate the unique numeric ID -- just count
MMutex mutex_id;
DWORD g_currentID = 1;
//
DWORD GenID()
{
	ASSERT(g_currentID);
	MLock lock(mutex_id);
	return ++g_currentID;
}
//

void GUID::Create(GUID* pGuid)
{
	for(int n=0; n<16; ++n)
		pGuid->a[n]= (u_char)(0xFF & rand());// hacky, isnt it?
}

const GUID GUID::G_NULL = {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};

void MakeLower(char * szStr)
{
	for (int n = strlen(szStr)-1; n>=0; --n)
	{
		if (szStr[n]>='A' && szStr[n]<='Z')
			szStr[n]+= 'a' - 'A';
	}
}

void MakeUpper(char * szStr)
{
	for (int n = strlen(szStr)-1; n>=0; --n)
	{
		if (szStr[n]>='a' && szStr[n]<='z')
			szStr[n]-= 'a' - 'A';
	}
}

inline bool IsWhite(char c)
{
	return isspace(c);
}

char* StripWhite( char* string )
{
	register char *s, *t;
	for (s = string; IsWhite(*s); s++)
		;
	if (*s == 0)
		return (s);
	
	t = s + strlen (s) - 1;
	while (t > s && IsWhite(*t))
		t--;
	*++t = '\0';
	
	return s;
}

CString StripWhite (CString str)
{
	int s,t;
	int l = str.length();
	for (s = 0; s<l && IsWhite(str[s]); s++)
		;
	if (s == l)
		return "";
	
	for (t = l-1; t>=s && IsWhite(str[t]); t--)
		;
	if (t<s)
		return "";
	return str.substr(s,t-s+1);
}

void ReplaceSubStr(CString& str, CString search, CString replace)
{
	int nPos = 0;
	do
	{
		nPos = str.find(search,nPos);
		if (nPos>=0)
		{
			// for the case when search.length()==replace.length() it could be done in more efficient way
			str = str.substr(0,nPos) + replace + str.substr(nPos+search.length());
			nPos += replace.length();
		}
	}
	while (nPos >= 0);
}

bool asc2num( char * arg, double * pRet )
{
	char* szClean = StripWhite(arg);
	int neFactor = 0;
	int len = strlen(szClean);
	if ( 0 == len )
		return false;
	char pat[256];
	memset(pat,0,256);
	int j = 1;
	for (int i=1;i<255;i++)
		if (NULL==strchr("0123456789.bBkKmMgGeE-+",(char)i))
			if (strchr(szClean, (char)i))
				return false;
	// it still can be cheated with some --++10+2Ke15
	switch (szClean[len-1])
	{
		case 'b':
		case 'B':
			szClean[len-1]='\0';
			--len;
	}
	if (len<=0)
		return false;
	switch (szClean[len-1])
	{
		case 'g':
		case 'G':
			neFactor += 10;
		case 'm':
		case 'M':
			neFactor += 10;
		case 'k':
		case 'K':
			neFactor += 10;
			szClean[len-1]='\0';
	}
	if (len<=0)
		return false;
	*pRet = atof(szClean)*(1<<neFactor);
	return true;
}

bool asc2num( char * arg, int * pRet )
{
	double d;
	if (asc2num(arg,&d))
	{
		if (d > 0)
			*pRet = int(0.5+d);
		else
			*pRet = int(-0.5+d);
		return true;
	}
	return false;
}

bool CreateDirectory(const CString& dir)
{
	return 0==mkdir(ExpandPath(dir).c_str(), S_IRWXU);
}
/*bool MoveFile(CString old_path, CString new_path)
{
	//TODO: make it in a more appropriate way
	CString com = CString("cd \'") + ExpandPath("~/") + "\'; mv '" + ExpandPath(old_path) + "' '" + ExpandPath(new_path) + "'";
	return EXIT_SUCCESS==system(com.c_str());
}*/
bool MoveFile(const CString& old_path, const CString& new_path)
{
	return 0==rename(ExpandPath(old_path).c_str(), ExpandPath(new_path).c_str());
}
bool DeleteFile(const CString& path)
{
	return 0==unlink(ExpandPath(path).c_str());
}
bool FileExists(const CString& path)
{
	struct stat st;
	return 0==stat(ExpandPath(path).c_str(), &st) && (S_ISREG(st.st_mode) || S_ISDIR(st.st_mode));
}

CString ExpandPath(CString path)
{
	MLock lock(g_LibcMutex);
	if (path.find("~/") != -1)
	{
		CString home = getenv("HOME");
		if (home.length()>1)
		{
			home += "/";
			ReplaceSubStr(path,"~/",home);
		}
	}
	ReplaceSubStr(path,"//","/");
	return path;
}

bool QueryMatch(CString Result, const CString& Query)
{
	std::vector<char*> QWords;
	
	MakeLower(Result);

    int nQLen = Query.length();
    char* szQuery = new char[nQLen+1];
    strcpy(szQuery, Query.c_str());
    MakeLower(szQuery);
    // Break Query into words
    MakeWordList(szQuery, QWords);
    bool bMatch = false;
    if (QWords.size())
    	bMatch = MatchWordList(Result, QWords);
	delete [] szQuery;
	return bMatch;
}

void MakeWordList(LPSTR szQuery, std::vector<char*>& QWords)
{
	int nQLen = strlen(szQuery);
	// Break Query into words
	char* szWord;
	int i;
	char c;
	for (i = 0; i<nQLen; ++i)
	{
		c = szQuery[i];
		if ( isspace(c) || c=='*' || c=='+' )
			szQuery[i] = '\0';
	}
	for (i = 0; i<nQLen; ++i)
	{
		if ( szQuery[i] && (i==0 || !szQuery[i-1]) )
		{
			szWord = StripWhite(szQuery+i);
			if (strlen(szWord))
			{
				QWords.push_back(szWord);
			}
		}
	}
}

void MakeWordList(LPSTR szQuery, std::vector<char*>& QWordsInc, std::vector<char*>& QWordsExc)
{
	int nQLen = strlen(szQuery);
	// Break Query into words
	char* szWord;
	int i;
	char c;
	for (i = 0; i<nQLen; ++i)
	{
		c = szQuery[i];
		if ( isspace(c) || c=='*' || c=='+' )
			szQuery[i] = '\0';
	}
	for (i = 0; i<nQLen; ++i)
	{
		if ( szQuery[i] && (i==0 || !szQuery[i-1]) )
		{
			szWord = StripWhite(szQuery+i);
			if (strlen(szWord))
			{
				// if szWord starts with '-' -- this is an exclusive word
				if (szWord[0]=='-')
				{
					if (szWord[1] != '\0')
						QWordsExc.push_back(szWord+1);
				}
				else
					QWordsInc.push_back(szWord);
			}
		}
	}
}
	
bool MatchWordList(const CString& ResultLower, const std::vector<char*>& QWords, bool bMatchAll /*=true*/)
{
	if (!QWords.size())
		return false;
	std::vector<char*>::const_iterator itWord;
	// Search result for the those words
	for(itWord = QWords.begin(); itWord != QWords.end(); itWord++)
	{
		if( ResultLower.find(*itWord) != -1 )
		{
			if (!bMatchAll) // means match-any
				return true;
		}
		else
		{
			if (bMatchAll)
				return false;
		}
	}
	return bMatchAll;
}

CString MakeSearchOfFilename(const CString& Name)
{
	int nLen = Name.length();
	int bWhite = false;
	CString Search;
	char c;
	for (int i = 0; i<nLen; i++)
	{
		c = Name[i];
		if ( (c>='0' && c<='9') ||
		     (c>='A' && c<='Z') ||
		     (c>='a' && c<='z') )
		{
			if (bWhite)
			{
				Search+=' ';
				bWhite = false;
			}
			// make it lower
			if (c>='A' && c<='Z')
				c += 'a'-'A';
			Search+=c;
		}
		else
			bWhite = true;
	}
	// remove some redundant 'keywords'
	ReplaceSubStr(Search,"divx"," ");
	ReplaceSubStr(Search,"divx4"," ");
	ReplaceSubStr(Search,"mpeg4"," ");
	ReplaceSubStr(Search,"dvdrip"," ");
	ReplaceSubStr(Search," rip "," ");
	ReplaceSubStr(Search," en "," ");
	ReplaceSubStr(Search,"dvd"," ");
	ReplaceSubStr(Search,"vhs"," ");
	ReplaceSubStr(Search,"vhsrip"," ");
	ReplaceSubStr(Search,"dvdivx"," ");
	ReplaceSubStr(Search," cherami "," ");
	ReplaceSubStr(Search,"dominion"," ");
	ReplaceSubStr(Search,"smr"," ");
	ReplaceSubStr(Search,"ts pdivx"," ");//TS-PDivX
	ReplaceSubStr(Search," ts "," ");
	ReplaceSubStr(Search,"humr "," ");
	ReplaceSubStr(Search,"schizo"," ");
	//
	ReplaceSubStr(Search,"   "," ");
	ReplaceSubStr(Search,"  "," ");
	// remove starting and trailing spaces
	return StripWhite(Search);
}


/*CString GetFileError(CFileException* error)
{
	switch( error->m_cause )
	{

	case CFileException::none:
        return "Error Not Detected";
		break;
	case CFileException::generic:
        return "Generic Error";
		break;
	case CFileException::fileNotFound:
        return "File Not Found";
		break;
	case CFileException::badPath:
        return "Bad Path";
		break;
	case CFileException::tooManyOpenFiles:
        return "Too Many Open Files";
		break;
	case CFileException::accessDenied:
        return "Access Denied";
		break;
	case CFileException::invalidFile:
        return "Invalid File";
		break;
	case CFileException::removeCurrentDir:
        return "Cannot Remove Directory";
		break;
	case CFileException::directoryFull:
        return "Directory Full";
		break;
	case CFileException::badSeek:
        return "Error Seeking";
		break;
	case CFileException::hardIO:
        return "Hardware Error";
		break;
	case CFileException::sharingViolation:
        return "Sharing Violation";
		break;
	case CFileException::lockViolation:
        return "Lock Violation";
		break;
	case CFileException::diskFull:
        return "Disk Drive Full";
		break;
	case CFileException::endOfFile:
        return "End of File";
		break;
	}

	return "Error Unknown";
}

HICON GetIconFromName(CString File)
{
	DWORD dwBufLen = 255;

	HKEY hKey = NULL;
	HKEY pKey = NULL;

	HICON FileIcon = NULL;

	// Open icon key
	if(RegOpenKeyEx(HKEY_CLASSES_ROOT, TEXT( File.Mid( File.ReverseFind('.'))), 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS) 
	{	
		TCHAR szFileKey[255];
		RegQueryValueEx(hKey, NULL, NULL, NULL, (LPBYTE)szFileKey, &dwBufLen);
		
		CString FileKey(szFileKey);

		FileKey += "\\DefaultIcon";
		
		// Use the default key to open the icon name dir in the registry
		if(RegOpenKeyEx(HKEY_CLASSES_ROOT, FileKey, 0, KEY_QUERY_VALUE, &pKey) == ERROR_SUCCESS) 
		{

			TCHAR szPathKey[255];
			dwBufLen = 255;
			RegQueryValueEx(pKey, NULL, NULL, NULL, (LPBYTE)szPathKey, &dwBufLen);
				
			CString PathKey(szPathKey);
			int comma = PathKey.Find(',');
					
			// Extract the icon
			if(ExtractIconEx(PathKey.Mid(0, comma), atoi(PathKey.Mid(comma + 1)), NULL, &FileIcon, 1) == 0)
				FileIcon = NULL;
			
			RegCloseKey(pKey);
		}
		
		RegCloseKey(hKey);
	}

	// If we didn't find the icon display a default windows one
	if(FileIcon == NULL)
	{
		TCHAR szSysDir[MAX_PATH];

		GetSystemDirectory(szSysDir, sizeof (szSysDir));
		CString SysDir(szSysDir);

		// Check for .exe
		CString testExe = File.Mid( File.ReverseFind('.'));
		testExe.MakeLower();
		
		if(testExe == ".exe")
			ExtractIconEx(SysDir + "\\shell32.dll", 2, NULL, &FileIcon, 1);
		else
			ExtractIconEx(SysDir + "\\shell32.dll", 0, NULL, &FileIcon, 1);
	}

	return FileIcon;
}

CString GetIconDesc(CString File)
{
	DWORD dwBufLen = 255;

	HKEY hKey = NULL;
	HKEY pKey = NULL;
		
	CString IconDesc;

	// Open icon key
	if(RegOpenKeyEx(HKEY_CLASSES_ROOT, TEXT( File.Mid( File.ReverseFind('.'))), 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS) 
	{	
		TCHAR szFileKey[255];
		RegQueryValueEx(hKey, NULL, NULL, NULL, (LPBYTE)szFileKey, &dwBufLen);
		
		CString FileKey(szFileKey);
		
		// Use the default key to open the icon name dir in the registry
		if(RegOpenKeyEx(HKEY_CLASSES_ROOT, FileKey, 0, KEY_QUERY_VALUE, &pKey) == ERROR_SUCCESS) 
		{
			TCHAR szPathKey[255];
			dwBufLen = 255;
			RegQueryValueEx(pKey, NULL, NULL, NULL, (LPBYTE)szPathKey, &dwBufLen);
				
			IconDesc = szPathKey;
			
			RegCloseKey(pKey);
		}
		
		RegCloseKey(hKey);
	}

	// If we didn't find the icon display a default windows one
	if(IconDesc == "")
	{
		IconDesc = File.Mid( File.ReverseFind('.') + 1 );

		IconDesc.MakeUpper();

		IconDesc += " File";
	}

	return IconDesc;
} */




