#define _LARGEFILE64_SOURCE     /* required for GLIBC to enable stat64 and friends */
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <regex.h>

#include "mt.h"
#include "version.h"


void error_exit(char *format, ...)
{
	va_list ap;

	(void)endwin();

	fprintf(stderr, version_str, VERSION);
	fprintf(stderr, "\n\n");

	va_start(ap, format);
	(void)vfprintf(stderr, format, ap);
	va_end(ap);
	if (errno) fprintf(stderr, "errno: %d=%s (if applicable)\n", errno, strerror(errno));
	fprintf(stderr, "\nPress enter to exit.\n");
	getchar();

	(void)kill(0, SIGTERM); /* terminate every process in the process group of the current process */

	exit(EXIT_FAILURE);
}

