# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - Render an extra hint at top of MissingPage

    @copyright: 2006 MoinMoin:ThomasWaldmann
    @license: GNU GPL, see COPYING for details.
"""

Dependencies = ["language", "namespace", "user", ]

def execute(macro, args):
    request = macro.request
    _ = request.getText
    page = request.page
    user = request.user
    create_allowed = user.may.write(page.page_name)
    exists = page.exists()
    has_existed = page.exists(includeDeleted=1)
    if not create_allowed:
        text = _(u"""'''You are not allowed to create this page!'''""")
    elif not exists and has_existed:
        text = _(u"""'''This page has already existed and was deleted. Use info action to see (or even revert) previous revisions.'''""")
    else:
        text = u'%r %r' % (exists, has_existed)
    return text

