/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: process.c,v 1.9 2001/12/28 17:57:26 ostborn Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>

#include "config.h"
#include "mrecord.h"
#include "mlocale.h"
#include "mconfig.h"
#include "mplugins.h"
#include "mstate.h"
#include "mdatatypes.h"
#include "datatypes/count/datatype.h"
#include "datatypes/state/datatype.h"
#include "misc.h"
#include "plugin_config.h"

int mplugins_processor_insert_record(mconfig *ext_conf, mlist *state_list, mlogrec *record) {
	mlogrec_telecom *rectel = NULL;
	config_processor *conf = ext_conf->plugin_conf;
	mstate_telecom *statel = NULL;
	struct tm *tm;
	/* State */
	mdata *data = state_list->data;
	mstate *state = NULL;
	
	if (!data) {
		data = mdata_State_create("",NULL,NULL);
		mlist_insert(state_list, data);
	}
	
	if (record->ext_type != M_RECORD_TYPE_TELECOM) return -1;
	
	if (record->ext == NULL) return -1;
	
	rectel = record->ext;
	
	state = data->data.state.state;
	
	if (ext_conf->debug_level > 2) {
		if (rectel->direction == M_RECORD_TELECOM_DIRECTION_IN) {
			printf("%-3s <- %-30s (%lds)\n", rectel->called_number, rectel->calling_number, rectel->duration);
		} else {
			printf("%-3s -> %-30s (%lds)\n", rectel->calling_number, rectel->called_number, rectel->duration);
		}
	}
	
	/* if we have a subprocessor, call it */
	if (conf->sub_processor) {
		conf->sub_processor->insert_record(ext_conf, state_list, record);
	}
	
	if (state->ext) {
		switch(state->ext_type) {
		case M_STATE_TYPE_TELECOM:
			statel = state->ext; break;
		default:
			fprintf(stderr, "%s.%d: unsupport state subtype\n", __FILE__, __LINE__);
			return -1;
		}
	} else {
		state->ext = mstate_init_telecom();
		state->ext_type = M_STATE_TYPE_TELECOM;
		
		statel = state->ext;
	}
	
/* hourly/daily stats */
	if ((tm = localtime(&(record->timestamp)))) {
		if (rectel->direction == M_RECORD_TELECOM_DIRECTION_IN) {
			statel->hours[tm->tm_hour].incomming_calls++;
			statel->days[tm->tm_mday-1].incomming_calls++;
		} else {
			statel->hours[tm->tm_hour].outgoing_calls++;
			statel->days[tm->tm_mday-1].outgoing_calls++;
		}
	}
	
	if (rectel->called_number) {
		data = mdata_Count_create(rectel->called_number, 1, M_DATA_STATE_PLAIN);
		mhash_insert_sorted(statel->called_numbers, data);
	}
	
	if (rectel->calling_number) {
		data = mdata_Count_create(rectel->calling_number, 1, M_DATA_STATE_PLAIN);
		mhash_insert_sorted(statel->calling_numbers, data);
	}

	return 0;
}



