/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.4 2001/12/25 13:59:36 ostborn Exp $
*/
#ifndef _OUTPUT_PLUGIN_CONFIG_H_
#define _OUTPUT_PLUGIN_CONFIG_H_

#include <stdio.h>
#include "mlist.h"

typedef struct {
/* colors */	
	char *col_backgnd;
	char *col_shadow;
	char *col_pages;
	char *col_files;
	char *col_hosts;
	char *col_visits;
	char *col_xfer;
	char *col_hits;
	char *col_grouping;
	char *col_body;
	
	char *hostname;
	
/* webalizer output plugin */
	int max_req_urls;
	int max_os;
	int max_hosts;
	int max_ref_urls;
	int max_entry_pages;
	int max_exit_pages;
	int max_indexed_pages;
	int max_ua;
	int max_req_prot;
	int max_req_meth;
	int max_status_codes;
	int max_robots;
	int max_bookmarks;
	int max_broken_links;
	int max_internal_errors;
	int max_search_engines;
	int max_search_strings;
	int max_countries;
} config_output;

int mplugins_output_webalizer_generate_history_output(mconfig *ext_conf, mlist *history, const char *subpath);
int mplugins_output_webalizer_generate_monthly_output(mconfig *ext_conf, mstate *state, const char *subpath);

#endif
