/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.6 2001/08/28 23:28:32 jk Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <limits.h>

#include "mconfig.h"
#include "mstate.h"
#include "mlocale.h"
#include "mhash.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mplugins.h"

#include "plugin_config.h"
#ifdef SUBPROCESSOR
#include "subprocess.h"
#endif

int mplugins_output_null_dlinit(mconfig *ext_conf) {
	config_output *conf = NULL;
	
	conf = malloc(sizeof(config_output));
	memset(conf, 0, sizeof(config_output));
	
	ext_conf->plugin_conf = conf;

#ifdef SUBPROCESSOR
	return subprocessor_dlinit(ext_conf);
#endif
	
	return 0;
}

int mplugins_output_null_dlclose(mconfig *ext_conf) {
	config_output *conf = ext_conf->plugin_conf;

#ifdef SUBPROCESSOR
	subprocessor_dlclose(ext_conf);
#endif
	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	
	return 0;
}

int mplugins_output_null_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	int ret = 0;
	config_output *conf = ext_conf->plugin_conf;
	
	const mconfig_values config_values[] = {
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	if ((ret = mconfig_parse_section(ext_conf, filename, section, config_values)) != 0) {
#ifdef SUBPROCESSOR
		ret = subprocessor_parse_config(ext_conf, filename, section);
#endif
	}
	return ret;
}

int mplugins_output_null_set_defaults(mconfig *ext_conf) {
	config_output *conf = ext_conf->plugin_conf;

#ifdef SUBPROCESSOR
	return subprocessor_set_defaults(ext_conf);
#else
	return 0;
#endif
}

int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_output_null_dlinit;
	func->dlclose = mplugins_output_null_dlclose;
	func->parse_config = mplugins_output_null_parse_config;
	func->set_defaults = mplugins_output_null_set_defaults;
	func->get_next_record = NULL;
	func->insert_record = NULL;
	func->gen_report = mplugins_output_null_generate_monthly_output;
        func->gen_history = NULL;
	
	return 0;
}
