/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.27 2001/10/23 22:17:58 ostborn Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <limits.h>

#include "mconfig.h"
#include "mstate.h"
#include "mlocale.h"
#include "mhash.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mplugins.h"

#include "pictures.h"
#include "plugin_config.h"

int mplugins_output_modlogan_dlinit(mconfig *ext_conf) {
	config_output *conf = NULL;
	
	conf = malloc(sizeof(config_output));
	
	memset(conf, 0, sizeof(config_output));
	
	conf->col_circle = mlist_init();
	conf->col_vhostcircle = mlist_init();
	
	ext_conf->plugin_conf = conf;
	
	return 0;
}

int mplugins_output_modlogan_dlclose(mconfig *ext_conf) {
	config_output *conf = ext_conf->plugin_conf;

	if (conf->cssfile)	free(conf->cssfile);
	if (conf->col_visits)	free(conf->col_visits);
	if (conf->col_hits)	free(conf->col_hits);
	if (conf->col_files)	free(conf->col_files);
	if (conf->col_backgnd)	free(conf->col_backgnd);
	if (conf->col_foregnd)	free(conf->col_foregnd);
	if (conf->col_border)	free(conf->col_border);
	if (conf->col_shadow)	free(conf->col_shadow);
	if (conf->col_pages)	free(conf->col_pages);
	if (conf->col_xfer)	free(conf->col_xfer);
	if (conf->page_style)	free(conf->page_style);
	if (conf->html_header)	free(conf->html_header);
	if (conf->html_footer)	free(conf->html_footer);
	if (conf->assumedprotocol)	free(conf->assumedprotocol);
	if (conf->hostname)	free(conf->hostname);

	/* Added by Georges 'Melkor' Goncalves <melkor@lords.com>
	** courtesy of Jan Kneschke
	*/
	/* suffix for the generated statistics page files */
	if (conf->pages_suffix)	free(conf->pages_suffix);
	
	mlist_free(conf->col_circle);
	mlist_free(conf->col_vhostcircle);

	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	
	return 0;
}

int mplugins_output_modlogan_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_output *conf = ext_conf->plugin_conf;
	
	const mconfig_values config_values[] = {
	/* color tripples */
		{"background",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_backgnd)},
		{"foreground",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_foregnd)},
		{"border",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_border)},
		{"shadow",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_shadow)},
		{"pages",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_pages)},
		{"files",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_files)},
		{"visits",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_visits)},
		{"xfer",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_xfer)},
		{"hits",	M_CONFIG_TYPE_COLTRIPPL, M_CONFIG_VALUE_OVERWRITE, &(conf->col_hits)},
	/* mlist - StrInt */
		{"country_circle",	M_CONFIG_TYPE_STRING_LIST, M_CONFIG_VALUE_APPEND, &(conf->col_circle)},
		{"vhost_circle",        M_CONFIG_TYPE_STRING_LIST, M_CONFIG_VALUE_APPEND, &(conf->col_vhostcircle)},
	/* integer */
		{"maxrequrls",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_req_urls)},
		{"maxos",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_os)},
		{"maxhosts",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_hosts)},
		{"maxrefurls",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_ref_urls)},
		{"maxentrypages", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_entry_pages)},
		{"maxexitpages", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_exit_pages)},
		{"maxindexedpages", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_indexed_pages)},
		{"maxua",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_ua)},
		{"maxreqprot",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_req_prot)},
		{"maxreqmeth",	M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_req_meth)},
		{"maxstatuscodes", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_status_codes)},
		{"maxbookmarks", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_bookmarks)},
		{"maxbrokenlinks", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_broken_links)},
		{"maxsearchengines", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_search_engines)},
		{"maxsearchstrings", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_search_strings)},
		{"maxinteralerrors", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_internal_errors)},
		{"maxcountries", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_countries)},
		{"maxrobots", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_robots)},
		{"maxextensions", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_extensions)},
		{"maxvisitpaths", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_visit_paths)},
		{"maxvisitdurations", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_visit_durations)},
		{"maxvisitpathlengths", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_visit_path_lengths)},
		{"maxviewdurations", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->max_view_durations)},
		{"maxvhosts", M_CONFIG_TYPE_INT,        M_CONFIG_VALUE_OVERWRITE, &(conf->max_vhosts)},
		
		{"showdailygraph", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->show_daily_graph)},
		{"showmonthlygraph", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->show_monthly_graph)},
		{"showhourlygraph", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->show_hourly_graph)},
		{"showcountrygraph", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->show_country_graph)},
		{"showvhostgraph", M_CONFIG_TYPE_INT,   M_CONFIG_VALUE_OVERWRITE, &(conf->show_vhost_graph)},
		{"dont_escape_entities", M_CONFIG_TYPE_INT, M_CONFIG_VALUE_OVERWRITE, &(conf->dont_escape_entities)},
		{"dont_cut_urls", M_CONFIG_TYPE_INT,	M_CONFIG_VALUE_OVERWRITE, &(conf->dont_cut_urls)},
		{"showvalidationlinks", M_CONFIG_TYPE_INT, M_CONFIG_VALUE_OVERWRITE, &(conf->show_validation_links)},
	/* strings */	
		{"pagestyle", M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->page_style)},
		{"assumedprotocol", M_CONFIG_TYPE_STRING, M_CONFIG_VALUE_OVERWRITE, &(conf->assumedprotocol)},
		{"hostname", M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->hostname)},
		{"content_language", M_CONFIG_TYPE_STRING, M_CONFIG_VALUE_OVERWRITE, &(conf->cont_language)},
		{"content_charset", M_CONFIG_TYPE_STRING, M_CONFIG_VALUE_OVERWRITE, &(conf->cont_charset)},
		{"htmlfooter", M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->html_footer)},
		{"htmlheader", M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->html_header)},
		{"cssfile", M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->cssfile)},

		/* Added by Georges 'Melkor' Goncalves <melkor@lords.com>
		** courtesy of Jan Kneschke
		*/
		/* suffix for the generated statistics page files */
		{"pages_suffix", M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->pages_suffix)},
		
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	return mconfig_parse_section(ext_conf, filename, section, config_values);
}

int mplugins_output_modlogan_set_defaults(mconfig *ext_conf) {
	config_output *conf = ext_conf->plugin_conf;
#define LOCALHOST	"localhost"
#define CONT_LANG	"en"
#define CONT_CHARSET	"iso-8859-1"
/* Added by Georges 'Melkor' Goncalves <melkor@lords.com>
** courtesy of Jan Kneschke
*/
/* suffix for the generated statistics page files */
#define PAGES_SUFFIX "html"
	
	if (conf->hostname == NULL) {
		conf->hostname = malloc(strlen(LOCALHOST)+1);
		strcpy(conf->hostname, LOCALHOST);
	}
	
	if (conf->cont_language == NULL) {
		conf->cont_language = malloc(strlen(CONT_LANG)+1);
		strcpy(conf->cont_language, CONT_LANG);
	}
	
	if (conf->cont_charset == NULL) {
		conf->cont_charset = malloc(strlen(CONT_CHARSET)+1);
		strcpy(conf->cont_charset, CONT_CHARSET);
	}

	/* Added by Georges 'Melkor' Goncalves <melkor@lords.com>
	** courtesy of Jan Kneschke
	*/
	/* suffix for the generated statistics page files */
	if (conf->pages_suffix == NULL) {
		conf->pages_suffix = malloc(strlen(PAGES_SUFFIX)+1);
		strcpy(conf->pages_suffix, PAGES_SUFFIX);
	}
	
	
/* convert a negative value into the max value for the int 
   --> this means something like SHOW ME ALL
*/
#define LIMIT(x,y) \
	if (x < y) x = INT_MAX;
	
	LIMIT(conf->max_req_urls,0);
	LIMIT(conf->max_os,0);
	LIMIT(conf->max_hosts,0);
	LIMIT(conf->max_ref_urls,0);
	LIMIT(conf->max_entry_pages,0);
	LIMIT(conf->max_exit_pages,0);
	LIMIT(conf->max_indexed_pages,0);
	LIMIT(conf->max_ua,0);
	LIMIT(conf->max_req_prot,0);
	LIMIT(conf->max_req_meth,0);
	LIMIT(conf->max_status_codes,0);
	LIMIT(conf->max_robots,0);
	LIMIT(conf->max_bookmarks,0);
	LIMIT(conf->max_broken_links,0);
	LIMIT(conf->max_internal_errors,0);
	LIMIT(conf->max_search_engines,0);
	LIMIT(conf->max_search_strings,0);
	LIMIT(conf->max_countries,0);
#undef LIMIT	

	/* check if the colours are defined */
	if (!conf->col_backgnd || !conf->col_foregnd || !conf->col_border || !conf->col_shadow || !conf->col_pages ||
            !conf->col_files   || !conf->col_visits  || !conf->col_xfer   || !conf->col_hits) {
		fprintf(stderr, "%s.%d: not all required colours are set\n", __FILE__, __LINE__);
		return -1;
	}
	/* CSS File Defined? */
	if (!conf->cssfile) {
		fprintf(stderr, "%s.%d: cssfile isn't set\n", __FILE__, __LINE__);
		return -1;
	}
	
	return 0;
}

int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_output_modlogan_dlinit;
	func->dlclose = mplugins_output_modlogan_dlclose;
	func->parse_config = mplugins_output_modlogan_parse_config;
	func->set_defaults = mplugins_output_modlogan_set_defaults;
	func->get_next_record = NULL;
	func->insert_record = NULL;
	func->gen_report = mplugins_output_modlogan_generate_monthly_output;
	func->gen_history = mplugins_output_modlogan_generate_history_output;
	
	return 0;
}
