/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.8 2001/10/06 16:32:16 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>
#include <libxml/tree.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"
#include "mconfig.h"

/* begin of Count */

int mdata_Count_to_xml(gzFile *fd, mdata *data) {
#define WR(x,f) \
	gzprintf(fd, "<%s>%"#f"</%s>\n", #x, data->data.count.x, #x);
	
	WR(count, d);
	WR(grouped, d);
#undef WR


	return 0;
}

int mdata_Count_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_COUNT) return -1;
	
	return 0;
}

int mdata_Count_setdata(mdata *data, const char *str, int count, int type) {
	
	data->key	= malloc(strlen(str)+1);
	assert(data->key);
	strcpy(data->key, str);
	
	if (data->type == M_DATA_TYPE_UNSET) 
		data->type		= M_DATA_TYPE_COUNT;
	
	
	data->data.count.count		= count;
	data->data.count.grouped	= type;
	
	return 0;
}

int mdata_Count_from_xml(mstate_stack *m, int tagtype, mdata *data, int type, const xmlChar *value, const xmlChar **attrs) {
	int i;
	const mdata_values data_values[] = {
		{ "grouped", M_DATA_FIELDTYPE_LONG, 	&(data->data.count.grouped) },
		{ "count", M_DATA_FIELDTYPE_LONG, 	&(data->data.count.count) },
		
		{ NULL, M_DATA_FIELDTYPE_UNSET,  NULL}
	};
	
#if 0	
	M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
		 "|--> %s - %d\n", 
		 value, tagtype);
#endif 
	switch(tagtype) {
	case M_TAG_BEGIN:
		if (m->st_depth != m->st_depth_max) {
			M_DEBUG3(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "cur(depth) != max(depth) [%d - %d]- not my job (%s)\n",
				 m->st_depth, 
				 m->st_depth_max,
				 value);
			return -1;
		} else {
			for (i = 0; data_values[i].string != NULL && 0 != strcmp(data_values[i].string, value); i++)
				;
			if (data_values[i].string != NULL) {
				m->st_depth_max++;
				m->st[++m->st_depth].id = i + 1;
			} else {
				M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "unknown tag '%s'\n", 
					 value);
				return -1;
			}
		}
		break;
	case M_TAG_END:
		if (m->st_depth != m->st_depth_max) {
			M_DEBUG3(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "cur(depth) != max(depth) [%d - %d]- not my job (%s)\n",
				 m->st_depth, 
				 m->st_depth_max,
				 value);
			return -1;
		} else {
			for (i = 0; data_values[i].string != NULL && 0 != strcmp(data_values[i].string, value); i++)
				;
			if (data_values[i].string != NULL) {
				/* set data */
				if (data->type == M_DATA_TYPE_UNSET) 
					data->type		= M_DATA_TYPE_COUNT;
				
				m->st[m->st_depth].id = 0;
				m->st_depth_max--;
			} else {
				M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "unknown tag '%s'\n", 
					 value);
				return -1;
			}
		}
		break;
	case M_TAG_TEXT:
		if (m->st_depth != m->st_depth_max) {
			M_DEBUG3(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "cur(depth) != max(depth) [%d - %d]- not my job (%s)\n",
				 m->st_depth, 
				 m->st_depth_max,
				 value);
			return -1;
		} else {
			if (mdata_insert_value(m, tagtype, 
					       data_values[m->st[m->st_depth].id - 1].dest, 
					       data_values[m->st[m->st_depth].id - 1].type, 
					       value, attrs)) {
				M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "insert failed for '%s'\n", 
					 value);
				return -1;
			} else {
#if 0
				M_DEBUG2(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
					 "inserting '%s' for '%s'\n", 
					 value, data_values[m->st[m->st_depth] - 1].string);
#endif
			}
		}
		break;
	default:
		M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "can't handle tagtype '%d'\n", 
			 type);
		return -1;
	}

	return 0;
}



int mdata_Count_append(mdata *dst, mdata *src) {
	dst->data.count.count += src->data.count.count;
	
	return M_DATA_APPENDED;
}

mdata *mdata_Count_init() {
	mdata *data = mdata_init();
	assert(data);
	
	data->key		= NULL;
	data->type		= M_DATA_TYPE_COUNT;
	
#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */	
	data->data.count.count		= 0;
	data->data.count.grouped	= M_DATA_STATE_PLAIN;
	
	return data;
}

mdata *mdata_Count_copy(mdata *src) {
	mdata *data = mdata_Count_init();
	
	mdata_Count_setdata(data, src->key, src->data.count.count, src->data.count.grouped);
	
	return data;
}

mdata *mdata_Count_create(const char *str, int count, int type) {
	mdata *data = mdata_Count_init();
	
	mdata_Count_setdata(data, str, count, type);
	
	return data;
}

/* end of Count */
