/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.ElementFactory;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.utils.Base64Converter;
import com.fluendo.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;

public class HTTPSrc
extends Element {
    private String userId;
    private String password;
    private String userAgent = "Cortado";
    private String urlString;
    private InputStream input;
    private long contentLength;
    private long offset;
    private String mime;
    private Caps outCaps;
    private boolean discont;
    private URL documentBase;
    private boolean microSoft = false;
    private static final int DEFAULT_READSIZE = 4096;
    private int readSize = 4096;
    private Pad srcpad = new Pad(1, "src"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doSeek(Event event) {
            boolean bl;
            int n = event.parseSeekFormat();
            long l = event.parseSeekPosition();
            if (n == 5 && HTTPSrc.this.contentLength != -1L) {
                l = l * HTTPSrc.this.contentLength / 1000000L;
            } else if (n != 2) {
                Debug.log(2, "can only seek in bytes");
                return false;
            }
            Debug.log(4, this + " flushing");
            this.pushEvent(Event.newFlushStart());
            Object object = this.streamLock;
            synchronized (object) {
                Debug.log(4, this + " synced");
                bl = false;
                try {
                    HTTPSrc.this.input = HTTPSrc.this.getInputStream(l);
                    if (HTTPSrc.this.input != null) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.pushEvent(Event.newFlushStop());
                if (bl) {
                    this.pushEvent(Event.newNewsegment(false, 2, l, HTTPSrc.this.contentLength, l));
                    HTTPSrc.this.postMessage(Message.newStreamStatus(this, true, 0, "restart after seek"));
                    bl = this.startTask("cortado-HTTPSrc-Stream-" + Debug.genId());
                } else {
                    HTTPSrc.this.postMessage(Message.newError(this, "error: Seek failed"));
                }
            }
            return bl;
        }

        protected boolean eventFunc(Event event) {
            boolean bl;
            switch (event.getType()) {
                case 5: {
                    bl = this.doSeek(event);
                    break;
                }
                default: {
                    bl = super.eventFunc(event);
                }
            }
            return bl;
        }

        protected void taskFunc() {
            long l = HTTPSrc.this.contentLength != -1L ? (HTTPSrc.this.microSoft ? (HTTPSrc.this.contentLength == 0L ? 0L : HTTPSrc.this.contentLength - 1L - HTTPSrc.this.offset) : HTTPSrc.this.contentLength - HTTPSrc.this.offset) : -1L;
            int n = l != -1L && l < (long)HTTPSrc.this.readSize ? (int)l : HTTPSrc.this.readSize;
            Buffer buffer = Buffer.create();
            buffer.ensureSize(n);
            buffer.offset = 0;
            try {
                buffer.length = n > 0 ? HTTPSrc.this.input.read(buffer.data, 0, n) : -1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                buffer.length = 0;
            }
            if (buffer.length <= 0) {
                try {
                    HTTPSrc.this.input.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                buffer.free();
                Debug.log(3, this + " reached EOS");
                this.pushEvent(Event.newEOS());
                HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, -3, "reached EOS"));
                this.pauseTask();
            } else {
                HTTPSrc hTTPSrc = HTTPSrc.this;
                hTTPSrc.offset = hTTPSrc.offset + (long)buffer.length;
                if (HTTPSrc.this.srcpad.getCaps() == null) {
                    String string = ElementFactory.typeFindMime(buffer.data, buffer.offset, buffer.length);
                    if (string != null) {
                        if (!string.equals(HTTPSrc.this.mime)) {
                            Debug.log(2, "server contentType: " + HTTPSrc.this.mime + " disagrees with our typeFind: " + string);
                        }
                        Debug.log(3, "using typefind contentType: " + string);
                        HTTPSrc.this.mime = string;
                    } else {
                        Debug.log(3, "typefind failed, using server contentType: " + HTTPSrc.this.mime);
                    }
                    HTTPSrc.this.outCaps = new Caps(HTTPSrc.this.mime);
                    HTTPSrc.this.srcpad.setCaps(HTTPSrc.this.outCaps);
                }
                buffer.caps = HTTPSrc.this.outCaps;
                buffer.setFlag(1, HTTPSrc.this.discont);
                HTTPSrc.this.discont = false;
                int n2 = this.push(buffer);
                if (n2 != 0) {
                    if (Pad.isFlowFatal(n2) || n2 == -1) {
                        HTTPSrc.this.postMessage(Message.newError(this, "error: " + Pad.getFlowName(n2)));
                        this.pushEvent(Event.newEOS());
                    }
                    HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, n2, "reason: " + Pad.getFlowName(n2)));
                    this.pauseTask();
                }
            }
        }

        protected boolean activateFunc(int n) {
            boolean bl = true;
            switch (n) {
                case 0: {
                    HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, -2, "stopping"));
                    bl = this.stopTask();
                    HTTPSrc.this.input = null;
                    HTTPSrc.this.outCaps = null;
                    HTTPSrc.this.mime = null;
                    break;
                }
                case 1: {
                    try {
                        HTTPSrc.this.contentLength = -1L;
                        HTTPSrc.this.input = HTTPSrc.this.getInputStream(0L);
                        if (HTTPSrc.this.input == null) {
                            bl = false;
                        }
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!bl) break;
                    HTTPSrc.this.postMessage(Message.newStreamStatus(this, true, 0, "activating"));
                    bl = this.startTask("cortado-HTTPSrc-Stream-" + Debug.genId());
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    };

    private InputStream openWithConnection(URL uRL, long l) throws IOException {
        InputStream inputStream = null;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Connection", "Keep-Alive");
        String string = l != 0L && this.contentLength != -1L ? "bytes=" + l + "-" + (this.contentLength - 1L) : (l != 0L ? "bytes=" + l + "-" : null);
        if (string != null) {
            Debug.log(3, "doing range: " + string);
            uRLConnection.setRequestProperty("Range", string);
        }
        uRLConnection.setRequestProperty("User-Agent", this.userAgent);
        if (this.userId != null && this.password != null) {
            String string2 = String.valueOf(this.userId) + ":" + this.password;
            String string3 = Base64Converter.encode(string2.getBytes());
            uRLConnection.setRequestProperty("Authorization", "Basic " + string3);
        }
        uRLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        inputStream = uRLConnection.getInputStream();
        this.contentLength = (long)uRLConnection.getHeaderFieldInt("Content-Length", -1) + l;
        this.mime = uRLConnection.getContentType();
        this.offset = l;
        return inputStream;
    }

    private InputStream openWithSocket(URL uRL, long l) throws IOException {
        InputStream inputStream = null;
        String string = uRL.getHost();
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        Socket socket = new Socket(inetAddress, n);
        String string2 = uRL.getFile();
        OutputStream outputStream = socket.getOutputStream();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GET ").append(string2).append(" HTTP/1.0\r\n");
        stringBuffer.append("Content-Type: application/octet-stream\r\n");
        stringBuffer.append("Connection: Keep-Alive\r\n");
        String string3 = l != 0L && this.contentLength != -1L ? "bytes=" + l + "-" + (this.contentLength - 1L) : (l != 0L ? "bytes=" + l + "-" : null);
        if (string3 != null) {
            Debug.log(3, "doing range: " + string3);
            stringBuffer.append("Range: ").append(string3).append("\r\n");
        }
        stringBuffer.append("User-Agent: Cortado\r\n");
        if (this.userId != null && this.password != null) {
            String string4 = String.valueOf(this.userId) + ":" + this.password;
            String string5 = Base64Converter.encode(string4.getBytes());
            stringBuffer.append("Authorization: Basic ").append(string5).append("\r\n");
        }
        stringBuffer.append("\r\n\r\n");
        outputStream.write(stringBuffer.toString().getBytes());
        outputStream.flush();
        inputStream = socket.getInputStream();
        this.mime = "application/ogg";
        return inputStream;
    }

    private InputStream getInputStream(long l) throws Exception {
        InputStream inputStream = null;
        try {
            URL uRL;
            this.postMessage(Message.newResource(this, "Opening " + this.urlString));
            Debug.log(3, "reading from url " + this.urlString);
            boolean bl = this.urlString.startsWith("http://");
            if (!bl && this.documentBase != null) {
                Debug.log(3, "parsing in document base");
                uRL = new URL(this.documentBase, this.urlString);
            } else {
                Debug.log(3, "parsing as abslute URL");
                uRL = new URL(this.urlString);
            }
            Debug.log(3, "trying to open " + uRL + " at offset " + l);
            inputStream = this.openWithConnection(uRL, l);
            this.discont = true;
            if (this.contentLength != -1L) {
                this.postMessage(Message.newDuration(this, 2, this.contentLength));
            }
            Debug.log(3, "opened " + uRL);
            Debug.log(3, "contentLength: " + this.contentLength);
            Debug.log(3, "server contentType: " + this.mime);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            this.postMessage(Message.newError(this, "Not allowed " + this.urlString + "..."));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.postMessage(Message.newError(this, "Failed opening " + this.urlString + "..."));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.postMessage(Message.newError(this, "Failed opening " + this.urlString + "..."));
        }
        return inputStream;
    }

    public String getFactoryName() {
        return "httpsrc";
    }

    public HTTPSrc() {
        if (System.getProperty("java.vendor").toUpperCase().startsWith("MICROSOFT", 0)) {
            Debug.log(2, "Found MS JVM, work around inputStream EOS bugs.");
            this.microSoft = true;
        }
        this.addPad(this.srcpad);
    }

    public synchronized boolean setProperty(String string, Object object) {
        boolean bl = true;
        if (string.equals("url")) {
            this.urlString = String.valueOf(object);
        } else if (string.equals("documentBase")) {
            this.documentBase = (URL)object;
        } else if (string.equals("userId")) {
            this.userId = String.valueOf(object);
        } else if (string.equals("userAgent")) {
            this.userAgent = String.valueOf(object);
        } else if (string.equals("password")) {
            this.password = String.valueOf(object);
        } else if (string.equals("readSize")) {
            this.readSize = Integer.parseInt((String)object);
        } else {
            bl = false;
        }
        return bl;
    }
}

