#ifndef LIBXMP_MEMIO_H
#define LIBXMP_MEMIO_H

#include <stdio.h>

typedef struct {
	unsigned char *start;
	ptrdiff_t pos;
	ptrdiff_t size;
} MFILE;

#ifdef __cplusplus
extern "C" {
#endif

MFILE  *mopen(void *, long);
int     mgetc(MFILE *stream);
size_t  mread(void *, size_t, size_t, MFILE *);
int     mseek(MFILE *, long, int);
long    mtell(MFILE *);
int     mclose(MFILE *);
int	meof(MFILE *);
int	mstat(MFILE *, struct stat *);

#ifdef __cplusplus
}
#endif

#endif
