------------------------------------------------------------------------------
-- STRINGS                                                                  --
--                                                                          --
-- Part of TextTools                                                        --
-- Designed and Programmed by Ken O. Burtch                                 --
--                                                                          --
------------------------------------------------------------------------------
--                                                                          --
--                 Copyright (C) 1999-2007 Ken O. Burtch                    --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- This is maintained at http://www.pegasoft.ca/tt.html                     --
--                                                                          --
------------------------------------------------------------------------------
with common; use common;
  pragma Elaborate( common ); -- remind Ada the common elaborates first

package strings is

---> Misc Functions
--
-- FixSpacing - remove leading/trailing spaces, etc.
-- HashOf - compute a random value from the string
-- PhoneticsOf - compute English phonetics of the string
-- TypoOf - true if first string is a typo of the second
-- Tokenize - represent the position of the string in a list as an
--            encoded character, or ' ' if not in list or list too long
-- Untokenize - return the string represented by the encoded character
-- FGREP - search for a string is a list of text
-- SED   - search for a string in a list of text and operate on it
-- AWK   - UNIX awk on a list of text

procedure FixSpacing( s : in out str255 );
function HashOf( hashstr : str255 ) return long_integer;
function PhoneticsOf( s : str255 ) return str255;
function TypoOf( BadString, GoodString : Str255 ) return boolean;
procedure Tokenize( s : str255; words : in out Str255List.List;
   ch : in out character );
procedure Untokenize( ch : character ; words : in out Str255List.List;
  s : in out str255 );
function  ToUpper( s : str255 ) return str255;
function  ToLower( s : str255 ) return str255;
function  FGREP( s : str255; text : str255; filter_out : boolean := false;
  case_insensitive : boolean := false ) return boolean;
function  FGREP( s : str255; text : str255; filter_out : boolean := false;
  case_insensitive : boolean := false ) return str255;
procedure FGREP( s : str255; text : in out Str255List.List;
  filter_out : boolean := false; case_insensitive : boolean := false );
procedure FGREP( s : str255; text : in out Str255List.List;
  result : out boolean; filter_out : boolean := false;
  case_insensitive : boolean := false );
procedure SED( sedexpr : str255; text : in out Str255List.List );
procedure AWK( awkexpr, text : in out Str255List.List );

---> ASCII Encoding/Decoding
--
-- Compresses and appends a basic data item to the given string

subtype EncodedString is str255;

procedure Encode( estr : in out EncodedString; b : boolean );
procedure Encode( estr : in out EncodedString; c : character );
procedure Encode( estr : in out EncodedString; i : integer );
procedure Encode( estr : in out EncodedString; l : long_integer );
procedure Encode( estr : in out EncodedString; r : ARect );
procedure Encode( estr : in out EncodedString; s : str255 );

procedure Decode( estr : in out EncodedString; b : in out boolean );
procedure Decode( estr : in out EncodedString; c : in out character );
procedure Decode( estr : in out EncodedString; i : in out integer );
procedure Decode( estr : in out EncodedString; l : in out long_integer );
procedure Decode( estr : in out EncodedString; r : in out ARect );
procedure Decode( estr : in out EncodedString; s : in out str255 );

type packed_string is new string;


--  BASIC PACK
--
-- Compress string s using dipthong compression resulting in a new string of
-- 50% to 100% the size of the original.  s must contain only lower ASCII
-- characters since the upper ASCII characters are used for the compression.
------------------------------------------------------------------------------

function basic_pack( s : string ) return packed_string;


--  UNPACK
--
-- Decompress string s that was compressed using basic_pack.
------------------------------------------------------------------------------

function unpack( s : packed_string ) return string;


end strings;

