#ifndef __INCLUDED_DEBUG_H__
#define __INCLUDED_DEBUG_H__

#ifndef PHIDGETS_INTERNAL
#  error "this file is only supposed to be used from within libphidgets."
#endif /* PHIDGETS_INTERNAL */

#include <phidgets/phidgets.h>

extern PhidgetDebugLevel phidgets_debug_level;
extern FILE* phidgets_debug_stream;

#define DEBUGPRINTF(t, s, a...) if (phidgets_debug_stream) { \
                                  fprintf(phidgets_debug_stream, "%s: %s(): ", t, __FUNCTION__); \
                                  fprintf(phidgets_debug_stream, s "\n", ##a); \
                                }
#define TRACE(s, a...) if (phidgets_debug_level & HID_DEBUG_TRACES) { DEBUGPRINTF("  TRACE", s, ##a) }
#define NOTICE(s, a...) if (phidgets_debug_level & HID_DEBUG_NOTICES) { DEBUGPRINTF(" NOTICE", s, ##a) }
#define WARNING(s, a...) if (phidgets_debug_level & HID_DEBUG_WARNINGS) { DEBUGPRINTF("WARNING", s, ##a) }
#define ERROR(s, a...) if (phidgets_debug_level & HID_DEBUG_ERRORS) { DEBUGPRINTF("  ERROR", s, ##a) }

#endif /* __INCLUDED_DEBUG_H__ */

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2005 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
