/***************************************************************************
                          chublistmanager.h  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHUBLISTMANAGER_H
#define CHUBLISTMANAGER_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cthread.h>
#include <dclib/core/csingleton.h>
#include <dclib/core/cxml.h>
#include <dclib/core/clist.h>

class CClient;
class DCHubObject;
class CHubListManager;
class CMessageSearchFile;
class CStringList;
class CHttp;
class DCConfigHubListUrl;
class CByteArray;
class CDCMessage;
class CMessageMyInfo;
class CIconv;

class DLL_EXPORT CXmlColumn : public CObject {
public:
	/** */
	CXmlColumn()
	{
		m_sName = "";
		m_sType = "";
		m_sValue = "";
	};
	/** */
	virtual ~CXmlColumn() {};
	/** Column name */
	CString m_sName;
	/** Column type */
	CString m_sType;
	/** Column value */
	CString m_sValue;
};

#ifdef WIN32
template class DLL_EXPORT CSingleton<CHubListManager>;
#endif

class DLL_EXPORT CHubListManager : public CSingleton<CHubListManager> {
public:
	/** */
	CHubListManager();
	/** */
	virtual ~CHubListManager();

	/** callback function */
	virtual int DC_CallBack( CObject * ) { return -1; };

protected:
	/** */
	bool GetPublicHubList();
	/** */
	bool NextHubListUrl();

	/** */
	CThread m_Thread;

	/** */
	CHttp * m_pHttp;
	/** */
	CList<DCConfigHubListUrl> * m_pHubListUrlList;
	/** */
	DCConfigHubListUrl * m_pHubListUrl;
	/** */
	CByteArray * m_pHubListData;

private:
	/** http callback function */
	int HttpCallBack( CObject *, CObject * );
	/** thread callbackfunction */
	int Callback( CObject * , CObject * );
	/** */
	int ParsePublicHubList( CObject * , CObject * );
	/** Parses XML hublist, converting to .config format */
	int ParseXmlPublicHubList();
	/** Returns number of hubs parsed */
	int ParseXmlHubs( xmlNodePtr node, CIconv * pIconv );
	/** Gets column headings */
	void ParseXmlColumns( xmlNodePtr node, CList<CXmlColumn> * cols );
	/** Gets column values for one hub */
	void ParseXmlHub( xmlNodePtr node, CList<CXmlColumn> * cols, CIconv * pIconv );

	/** */
	time_t m_nReloadHubListTimeout;
	/** */
	bool m_bGetHubListDone;
	/** CXml object for parsing XML hublists */
	CXml * m_pXml;

	/** */
	_CCallback * m_pCallback;
};

#endif
