/*
 * hello.c
 *
 * A hello world application using the Bonobo UI handler
 *
 * Authors:
 *	Murray Cumming   <murrayc@usa.net>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#include <gtkmm/main.h>
#include "controlwidget.h"
#include <libbonoboui.h>

static BonoboObject* control_factory (BonoboGenericFactory *instance,
				      const char           *req_iid,
				      void                 *data)
{
    g_return_val_if_fail (req_iid != 0, 0);
    
    static const std::string iid = "OAFIID:Bonobomm_Sample_Entry";
    if (req_iid != iid)
	return 0;

    Gtk::Widget *control_w = new ControlWidget;
    Gnome::Bonobo::Servers::Control *control =
	new Gnome::Bonobo::Servers::Control (*manage (control_w));

    return BONOBO_OBJECT (control->gobj ());
}


int main (int argc, char* argv[])
{
    /* Setup translaton domain */
    //bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
    //textdomain (GETTEXT_PACKAGE);
    
    if (!bonobo_ui_init ("bonobo-hello", "1.0", &argc, argv))
	g_error (_("Cannot init libbonoboui code"));

    Gtk::Main main(argc, argv);

    return bonobo_generic_factory_main ("OAFIID:Bonobomm_Sample_ControlFactory",
					control_factory, 0);
}
