/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44Display_H
#define	JT44Display_H

#include <wx/wx.h>
#include <wx/listctrl.h>

#include "jt44/JT44Levels.h"
#include "jt44/JT44AverageMessage.h"
#include "jt44/JT44Message.h"

#include "JT44LevelGraph.h"

class CJT44Display : public wxPanel {
    public:
	CJT44Display(wxWindow* parent, int id = -1);
	virtual ~CJT44Display();

	virtual void onMessageSelected(const wxListEvent& event);
	virtual void onMessageClick(const wxListEvent& event);
	virtual void onAverageClick(const wxListEvent& event);

	virtual void onIncludeMessage(const wxCommandEvent& event);
	virtual void onExcludeMessage(const wxCommandEvent& event);
	virtual void onDecodeMessage(const wxCommandEvent& event);
	virtual void onClearMessages(const wxCommandEvent& event);
	virtual void onClearAverage(const wxCommandEvent& event);

	virtual void showLevels(CJT44Levels* levels) const;
	virtual void showMessage(CJT44Message* message);

	virtual void setMinSync(int level);

    private:
	CJT44LevelGraph*    m_graph;
	wxListCtrl*         m_messageListCtrl;
	wxListCtrl*         m_averageListCtrl;
	wxMenu*             m_messageMenu;
	wxMenu*             m_averageMenu;
	int                 m_listCount;
	int                 m_selected;
	int                 m_minSync;
	CJT44AverageMessage m_averageMessage;
	CJT44MessageList*   m_messageList;

	DECLARE_EVENT_TABLE()

	wxMenu* createMessageMenu();
	wxMenu* createAverageMenu();

	void    updateMessage(int n);
	void    updateAverage();

	CJT44Message* getMessage(int n) const;
};

#endif
