/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "Text.h"

#include <wx/debug.h>
#include <wx/log.h>

static wxString m_local;
static wxString m_remote;
static wxString m_locator;
static wxString m_report;

CText::CText(const wxString& text) :
m_text(text)
{
}

CText::~CText()
{
}

wxString CText::getOriginalText() const
{
	return m_text;
}

wxString CText::getReplacedText(unsigned int len) const
{
	wxString text = m_text;

	text.Replace(wxT("%M"), m_local);
	text.Replace(wxT("%T"), m_remote);
	text.Replace(wxT("%L"), m_locator);
	text.Replace(wxT("%R"), m_report);

	text.Replace(wxT("%"), wxEmptyString);

	if (len != 0 && !text.IsEmpty()) {
		wxString temp = text;

		while (text.Length() < len)
			text.Append(temp);

		if (text.Length() > len) {
			text.Truncate(len);
/*
			int pos = text.Find(wxT(' '), true);
			if (pos != -1) {
				for (unsigned int i = pos; i < len; i++)
					text.SetChar(i, wxT(' '));
			}
*/
		}
	}

	return text;
}

void CText::setLocalCallsign(const wxString& callsign)
{
	m_local = callsign;
}

void CText::setRemoteCallsign(const wxString& callsign)
{
	m_remote = callsign;
}

void CText::setLocalLocator(const wxString& locator)
{
	m_locator = locator;
}

void CText::setLocalReport(const wxString& report)
{
	m_report = report;
}
