/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SoundCard_H
#define	SoundCard_H

#include "SoundDev.h"

class CSoundCard : public CSoundDev {

    public:
    	CSoundCard();
    	CSoundCard(const wxString& fileName, int sampleRate, int sampleWidth);
	virtual ~CSoundCard();

	virtual void openWrite(const wxString& fileName, int sampleRate, int sampleWidth);
	virtual void openWrite();
	virtual void openRead(const wxString& fileName, int sampleRate, int sampleWidth);
	virtual void openRead();
	virtual bool read(double* sample, int& len);
	virtual void write(double* sample, int len, double volume);
	virtual void close();

    private:
	int      m_fd;
	wxString m_fileName;
	int      m_sampleRate;
	int      m_sampleWidth;
};

#endif
