/*
 * $Id: kl_dump_SN2_24X.c,v 1.1 2005/02/23 19:31:37 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2005 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <klib.h>
#include <stdint.h>
#include <sys/time.h>

/* Global variable that allows any code that needs to the ability to
 * take whatever action is necessary to support older style SGI dumps.
 * Note that this flag is only valid for ia64, SN2 dumps.
 */
int SN2_24X = 0;

#define DH_NAME_SN2_24X "_dump_header_s"
#define DHA_NAME_SN2_24X "_dump_header_asm_s"

/*
 * get_dump_header_SN2_24X()
 */
kl_dump_header_t *
get_dump_header_SN2_24X(void *rdh)
{
	kl_dump_header_t *dh;

	/* Make sure we reference the old dump header type names...
	 */
	dh_typename = DH_NAME_SN2_24X;
	dha_typename = DHA_NAME_SN2_24X;

	if (!rdh) {
		return((kl_dump_header_t *)NULL);
	}
	dh = (kl_dump_header_t *)malloc(sizeof(kl_dump_header_t));

	dh->magic_number = ((kl_dump_header_t *)rdh)->magic_number;
	dh->version = ((kl_dump_header_t *)rdh)->version;
	dh->header_size = ((kl_dump_header_t *)rdh)->header_size;
	dh->dump_level = ((kl_dump_header_t *)rdh)->dump_level;
	dh->page_size = ((kl_dump_header_t *)rdh)->page_size;
	dh->memory_size = ((kl_dump_header_t *)rdh)->memory_size;
	dh->memory_start = ((kl_dump_header_t *)rdh)->memory_start;
	dh->memory_end = ((kl_dump_header_t *)rdh)->memory_end;
	dh->num_dump_pages = ((kl_dump_header_t *)rdh)->num_dump_pages;

	memcpy(dh->panic_string, ((kl_dump_header_t *)rdh)->panic_string,
		KL_DUMP_PANIC_LEN);

	dh->time.tv_sec   = ((kl_dump_header_t *)rdh)->time.tv_sec;
	dh->time.tv_usec  = ((kl_dump_header_t *)rdh)->time.tv_usec;

	/* From this point on, we need to access the member via struct
	 * name/offset.
	 */
	memcpy(dh->utsname_sysname, K_PTR(rdh, 
		dh_typename, "dh_utsname_sysname"), KL_UTS_LEN);
	memcpy(dh->utsname_nodename, K_PTR(rdh, 
		dh_typename, "dh_utsname_nodename"), KL_UTS_LEN);
	memcpy(dh->utsname_release, K_PTR(rdh, 
		dh_typename, "dh_utsname_release"), KL_UTS_LEN);
	memcpy(dh->utsname_version, K_PTR(rdh, 
		dh_typename, "dh_utsname_version"), KL_UTS_LEN);
	memcpy(dh->utsname_machine, K_PTR(rdh, 
		dh_typename, "dh_utsname_machine"), KL_UTS_LEN);
	memcpy(dh->utsname_domainname, K_PTR(rdh, 
		dh_typename, "dh_utsname_domainname"), KL_UTS_LEN);
	memcpy(&dh->current_task, 
		K_PTR(rdh, dh_typename, "dh_current_task"), 8);
	memcpy(&dh->dump_compress, 
		K_PTR(rdh, dh_typename, "dh_dump_compress"), 4);
	memcpy(&dh->dump_flags, 
		K_PTR(rdh, dh_typename, "dh_dump_flags"), 4);
	memcpy(&dh->dump_device, 
		K_PTR(rdh, dh_typename, "dh_dump_device"), 4);
	memcpy(&dh->dump_buffer_size, 
		K_PTR(rdh, dh_typename, "dh_dump_buffer_size"), 8);

	SN2_24X = 1;

	return(dh);
}
