/*
 * $Id: kl_mem_s390.h,v 1.1 2004/12/21 23:26:22 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __KL_MEM_S390_H
#define __KL_MEM_S390_H

#define KL_KSTACK_SIZE_S390        0x2000ULL
#define KL_PAGE_OFFSET_S390        0x0

#define KL_PAGE_SHIFT_S390         12
#define KL_PAGE_SIZE_S390          (1UL << KL_PAGE_SHIFT_S390)
#define KL_PAGE_MASK_S390          (~(KL_PAGE_SIZE_S390-1))

#define KL_PGDIR_SHIFT_S390        20
#define KL_PGDIR_SIZE_S390         (1UL << KL_PGDIR_SHIFT_S390)
#define KL_PGDIR_MASK_S390         (~(KL_PGDIR_SIZE_S390-1))

#define KL_PMD_SHIFT_S390          KL_PGDIR_SHIFT_S390
#define KL_PMD_SIZE_S390           KL_PGDIR_SIZE_S390
#define KL_PMD_MASK_S390           KL_PGDIR_MASK_S390

#define KL_PTRS_PER_PGD_S390       2048
#define KL_PTRS_PER_PMD_S390       1
#define KL_PTRS_PER_PTE_S390       256

#define KL_PMD_BASE_MASK_S390      (~((1UL<<6)-1))
#define KL_PT_BASE_MASK_S390       KL_PMD_BASE_MASK_S390
#define KL_PAGE_BASE_MASK_S390     (~((1UL<<12)-1))

/* Flags used in entries of page dirs and page tables. 
 */
#define KL_PAGE_PRESENT_S390   0x001 /* set: loaded in physical memory
				      * clear: not loaded in physical mem */
#define KL_PAGE_RO_S390	       0x200 /* HW read-only */
#define KL_PAGE_INVALID_S390   0x400 /* HW invalid */
#define KL_PAGE_INVALID_MASK_S390 0x601ULL /* for linux 2.6 */
#define KL_PAGE_INVALID_NONE_S390 0x401ULL /* for linux 2.6 */
#define KL_PAGE_TABLE_LEN_S390 0xf   /* only full page-tables */
#define KL_PAGE_TABLE_INV_S390 0x20  /* invalid page-table               */

/* bit 0 must be zero in a segment table entry */
#define KL_PMD_INVALID_MASK_S390 (0x80000000)
#define KL_PMD_INVALID_S390(x) ((x) & KL_PMD_INVALID_MASK_S390)

/* bits 0, 20, 23 must contain zeroes in a pte*/
#define KL_PTE_INVALID_MASK_S390  0x80000900
#define KL_PTE_INVALID_S390(x) ((x) & KL_PTE_INVALID_MASK_S390)
 
/* pgd/pmd/pte query functions */ 
#define kl_pmd_none_s390(x) ((x) & KL_PAGE_TABLE_INV_S390)
#define kl_pmd_bad_s390(x) (((x) & (~KL_PMD_BASE_MASK_S390 & \
                                    ~KL_PAGE_TABLE_INV_S390)) != \
                            KL_PAGE_TABLE_LEN_S390)

#define kl_pte_none_s390(x) (((x) & (KL_PAGE_INVALID_S390 | KL_PAGE_RO_S390 | \
                                     KL_PAGE_PRESENT_S390)) == \
                             KL_PAGE_INVALID_S390)

/* functions needed for dump architecture specific memory mapping */
kaddr_t kl_mmap_virtop_s390(
	kaddr_t vaddr   /* kernel virtual address */,
	void *mmp       /* pointer to struct mm_struct */);

kaddr_t kl_kernelstack_s390(kaddr_t task);

#endif /* __ASM_KL_MEM_S390_H */
