/*
 * kl_mem_arm.h
 * 
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 * Ported to ARM/XScale architecture from kl_mem_i386.h 
 * by Fleming Feng (fleming.feng@intel.com)
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 * Copyright (C) 2003, Intel Corp. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __KL_MEM_ARM_H
#define __KL_MEM_ARM_H

#define KL_KSTACK_SIZE_ARM         0x2000ULL
#define KL_PAGE_OFFSET_ARM         0xc0000000

#define KL_PAGE_SHIFT_ARM          12
#define KL_PAGE_SIZE_ARM           (1UL << KL_PAGE_SHIFT_ARM)
#define KL_PAGE_MASK_ARM           (~(KL_PAGE_SIZE_ARM-1))

#define KL_PGDIR_SHIFT_ARM         20
#define KL_PGDIR_SIZE_ARM          (1UL<<KL_PGDIR_SHIFT_ARM)
#define KL_PGDIR_MASK_ARM          (~(KL_PGDIR_SIZE_ARM-1))
#define KL_PMD_SHIFT_ARM           KL_PGDIR_SHIFT_ARM
#define KL_PMD_SIZE_ARM            KL_PGDIR_SIZE_ARM
#define KL_PMD_MASK_ARM            KL_PGDIR_MASK_ARM

#define KL_PTRS_PER_PGD_ARM        4096
#define KL_PTRS_PER_PMD_ARM        1
#define KL_PTRS_PER_PTE_ARM        256

/* Used ULL to make masks valid for PAE case, too. */
#define KL_PMD_BASE_MASK_ARM       (~((1UL<<10)-1))
#define KL_PT_BASE_MASK_ARM        KL_PMD_BASE_MASK_ARM
#define KL_PAGE_BASE_MASK_ARM      KL_PMD_BASE_MASK_ARM

/* functions needed for dump architecture specific memory mapping */
kaddr_t kl_mmap_virtop_arm(
	kaddr_t vaddr   /* kernel virtual address */,
	void *mmp       /* pointer to struct mm_struct */);

int     kl_init_virtop_arm(void);

kaddr_t kl_kernelstack_arm(kaddr_t task);
kaddr_t kl_fix_vaddr_arm(kaddr_t, size_t);
int kl_virtop_arm(kaddr_t, void*, kaddr_t*);

#endif /* __KL_MEM_ARM_H */
