/*
 * $Id: kl_sysconfig.h,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libconfig.
 * A library which provides a framework for managing system hardware
 * and software configuration information.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef __KL_SYSCONFIG_H
#define __KL_SYSCONFIG_H

/* This struct is the header for system configuration information for all
 * system types. The hwcmp_root field points to all hardware components 
 * installed in the system (stored in an htree structure). Exactly what 
 * type of components are included is dependent on the type of system.
 */
typedef struct sysconfig_s {
	int		 flags;		/* K_PERM/K_TEMP, etc. */
	uint64_t	 sys_id;
	int		 sys_type;	/* IP type of system */
	time_t		 date; 		/* if 0 then sysconfig is current */
	hwconfig_t	*hwconfig;
	swconfig_t	*swconfig;
	hwcomponent_t	*hwcmp_archive;
	sw_component_t	*swcmp_archive;
} sysconfig_t;

#define hwcmp_root hwconfig->hwcp_root
#define hwcmp_cnt hwconfig->hwcp_cnt
#define swcmp_head swconfig->s_swcmp_head
#define swcmp_cnt swconfig->s_swcp_cnt

sysconfig_t *alloc_sysconfig(
	int		/* Flag value for block allocation (K_TEMP/K_PERM) */);

void free_sysconfig(
	sysconfig_t *	/* pointer to sysconfig_s struct */);

void update_sysconfig(
	sysconfig_t *	/* pointer to sysconfig_s struct */);

#endif /* __KL_SYSCONFIG_H */
