/*
 * $Id: lc_util.h,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __LC_UTIL_H
#define __LC_UTIL_H

void print_log_buf(FILE *);
char* get_utsname(void);
void dump_memory(kaddr_t, uint64_t, int, FILE*);
int  i_fprintf(FILE*, const char*, char*);
void init_liballoc(int, int, int);
int  get_string(char*, int);
void symbol_banner(FILE*, int);
void print_kaddr(kaddr_t, FILE*, int);
void print_version_info(FILE*);
int  get_first_task(kaddr_t*);
int  set_klib_dbg_components(const char*);
const char *get_klib_dbg_components(void);

#endif /* __LC_UTIL_H */
