/*
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 *
 * Added support for X86_64 architecture Mar 2004
 *      Prashanth Tamraparni (prasht@in.ibm.com)
 *      Sachin Sant (sachinp@in.ibm.com)
 */

#ifndef __LC_TRACE_X86_64_H
#define __LC_TRACE_X86_64_H

#define STACK_SEGMENTS_X86_64	1
#define STACK_SIZE_X86_64         KL_KSTACK_SIZE_X86_64

#define NR_EXCEPTION_STACKS_X86_64 	3
#define EXCEPTION_STACK_SIZE_X86_64	KL_PAGE_SIZE_X86_64
#define IRQ_STACK_SIZE_X86_64		(KL_PAGE_SIZE_X86_64 << 2)

/* Stack frame updating macro */
#define UPDATE_FRAME_X86_64(FUNCNAME, PC, RA, SP, FP, ASP, SRCNAME, LINE_NO, \
                          SIZE, FLAG) \
        curframe->funcname = FUNCNAME; \
        curframe->pc = PC; \
        curframe->sp = SP; \
        curframe->ra = RA; \
        curframe->fp = FP; \
        curframe->asp = ASP; \
        curframe->srcfile = SRCNAME; \
        curframe->line_no = LINE_NO; \
        curframe->frame_size = SIZE; \
        curframe->ptr = curstkidx; \
        kl_enqueue((element_t **)&trace->frame, (element_t *)curframe); \
        trace->nframes++; \
        curframe->flag |=FLAG;\

/* flag field of sframe_t */
#define EX_FRAME_X86_64 0x1 /* this frame is an interrupt or exception 
			   * frame, pt_regs field of sframe_t is valid 
			   * in this case */
/*
 * function prototypes
 */

/* init trace stuff for x86_64 dumps */
int trace_init_x86_64(void);

#endif /* __LC_TRACE_X86_64_H */
