/***************************************************************************
                          kxe_treeview.h  -  description
                             -------------------
    begin                : Thu Sep 20 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXE_TREEVIEW_H
#define KXE_TREEVIEW_H

#include <klistview.h>

class XmlElement;
class XmlContentsItem;
class XmlProcessingInstruction;
class SearchDlg;

class QMouseEvent;
class KXMLGUIClient;

/**
 * This is a listview, which displays the XML tree structure.
 * @short shows XML tree
 */
class KXE_TreeView : public KListView
{
		Q_OBJECT

	public:
		KXE_TreeView( KXMLGUIClient * pGUIClient, QWidget * pParent = 0, const char * pszName = 0 );
		virtual ~KXE_TreeView() {}

		/** Changes the behaviour of this view to readonly or readwrite. */
		void setReadWrite( bool fReadWrite );

		/** selects the XML object with the given path
		 *  returns true on success, false otherwise */
		bool selectItem( const QString & szPath );

	public slots:

		// configuration slots
		//////////////////////////////////////////////////////////////

		/** Sets the root elements decorated/not decorated, depending on the given parameter. */
		void slotConfigRootDecorated( bool isDecorated );
		/**
		 * Changes the display mode for XML elements.
		 * @param iMode 0 - Show only element names, 1 - Show element and attribute names, 2 - Show element and attribute names and attribute values
		 */
		void slotConfigElemDisplayMode( unsigned int iMode );
		/** Enables/Disables drag'n'drop depending on the given parameter. */
		void slotConfigDragDrop( bool bEnable );

		// action slots
		//////////////////////////////////////////////////////////////

		/** displays search dialog and finds string in this tree view */
		void slotEditFind();
		/** finds next occurence of string in this tree view */
		void slotEditFindNext();
		/** deselects currently selected item */
		void slotEditDeselect();
		/** Selects the selected item's parent item. */
		void slotViewNodeUp();
		/** Expands the selected tree item's subtree to the given level. */
		void slotViewExpNode( int nLevel );
		/** Collapses the selected tree item's subtree to the given level. */
		void slotViewColNode( int nLevel );
		/** toggles bookmark on the selected item */
		void slotBookmarksToggle();
		/** searches for the next bookmarked item */
		void slotBookmarksPrev();
		/** searches for the previous bookmarked item */
		void slotBookmarksNext();

	signals:
		/** emitted, when an XML element item is selected */
		void sigSelectionChanged( XmlElement * );
		/** emitted, when an XML Content item is selected */
		void sigSelectionChanged( XmlContentsItem * );
		/** emitted, when an XML proc.instr. item is selected */
		void sigSelectionChanged( XmlProcessingInstruction * );
		/**
		 * Signals the change of bookmark status.
		 * true -  item(s) bookmarked
		 * false - no item bookmarked
		 */
		void sigNewBookmarkStatus( bool fStatus );

	protected:
		/** if RMB shows the popupmenu corresponding to the selected item */
		void contentsMousePressEvent( QMouseEvent * );

		/** the GUI client, needed for the popupmenus */
		KXMLGUIClient * m_pGUIClient;
		/** the search dialog, used for find action */
		SearchDlg * m_pDlgSearch;
		/** number of bookmarked items */
		int m_nBookmarkCount;

	protected slots:
		/** Checks, which type of item was selected an emits the corresponding signal. */
		void slotSelectionChanged( QListViewItem * );
};

#endif
