/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink <katakombi@web.de>              *
 *   Copyright (C) 2004 by Nadeem Hasan <nhasan@nadmm.com>                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>

#include <kdebug.h>
#include <klocale.h>
#include <kparts/genericfactory.h>

#include "ksynaptics.h"
#include "synconfigwidget.h"
#include "touchpad.h"

typedef KGenericFactory<KSynaptics, QWidget> KSynapticsFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_ksynaptics, KSynapticsFactory("kcm_ksynaptics"))

//! for initializing on KDE start-up
extern "C" 
{
    KCModule *init_UserSettings(QWidget *, const char *)
    {
        // do initialization here
	    TouchPad::applyConfig();

        // ready :)
        return NULL;
    };
}


KSynaptics::KSynaptics(QWidget *parent, const char *name, const QStringList&)
    : KCModule(KSynapticsFactory::instance(), parent, name)
{
  // place widgets here
  QBoxLayout * l = new QHBoxLayout(this);

  m_widget  = new SynConfigWidget(this, "SynConfigWidget");
  l->add(m_widget);

  connect( m_widget, SIGNAL( changed() ), SLOT( changed() ) );

  m_aboutData = new KAboutData(I18N_NOOP("ksynaptics"), 
      I18N_NOOP("setting up the synaptics touch pad"),
      "0.2", I18N_NOOP("This kcmodule is based on the X11 Synaptics Driver"
      " (http://w1.894.telia.com/~u89404340/touchpad/)"),
      KAboutData::License_GPL, "(c) 2004 by Stefan Kombrink",
      0,"http://qsynaptics.sourceforge.net");

  m_aboutData->addAuthor("Stefan Kombrink",
      "http://qsynaptics.sourceforge.net", "katakombi@web.de");
  m_aboutData->addAuthor( "Nadeem Hasan", QString::null, "nhasan@kde.org" );
  // <--delete me  m_aboutData->addAuthor( "Andrea Dieni", QString::null, "andrea.dieni@aliceposta.it" );

  load();
};

KSynaptics::~KSynaptics()
{
}

void KSynaptics::load()
{
  kdDebug() <<  "load()" << endl;
  m_widget->load();
}

void KSynaptics::defaults()
{
}

void KSynaptics::save()
{
  kdDebug() << "save()" << endl;
  m_widget->save();
  TouchPad::applyConfig();
}

int KSynaptics::buttons()
{
  return Default|Apply|Help;
}

QString KSynaptics::quickHelp() const
{
  return i18n("This module helps you to use several advanced features"
              " of your synaptics touch pad.<br>");
}

#include "ksynaptics.moc"
