/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 
#include "adjborderwizard.h"
#include "myframe.h"
#include "touchpad.h"
#include "synconfig.h"
#include <kdebug.h>
#include <qpushbutton.h>

AdjBorderWizard::AdjBorderWizard() : AdjBorderWizardBase()
{ 
  frameLeft->displayPosition( LeftEdge );
  frameRight->displayPosition( RightEdge );
  frameUpper->displayPosition( TopEdge );
  frameLower->displayPosition( BottomEdge );

  hide();
  clearMeasuredResults();

  // clear averaged borders
  for (int i=0; i < 4; i++) 
    { m_X[i] = m_Y[i] = 0; }

  connect( this, SIGNAL( measurementDone() ), this, SLOT( allowProceed() ) );

  saveState();
  disableState();
}

void AdjBorderWizard::clearMeasuredResults()
{
  m_evCnt = m_avgX = m_avgY = 0;
}

void AdjBorderWizard::mouseMoveEvent( QMouseEvent * )
{
  m_evCnt++;

  m_avgX += TouchPad::absCoordX();
  m_avgY += TouchPad::absCoordY();

  if ( m_evCnt % m_numOfMinSamples == 0)
    // enough sample points measured
    emit measurementDone();
}

void AdjBorderWizard::next()
{
  showPage( page( indexOf( currentPage() ) + 1) );
  setNextEnabled( currentPage(), FALSE );
  setFinishEnabled( currentPage(), FALSE );
  clearMeasuredResults();
}

void AdjBorderWizard::back()
{
  showPage( page( indexOf( currentPage() ) - 1) );
  if ( indexOf( currentPage() ) > 0 )
  {
    setNextEnabled( currentPage(), FALSE );
    setFinishEnabled( currentPage(), FALSE );
  }
  clearMeasuredResults();
}

void AdjBorderWizard::allowProceed()
{
  int i = indexOf( currentPage() );

  // store averaged borders
  m_X[i-1] = m_avgX / m_evCnt;
  m_Y[i-1] = m_avgY / m_evCnt;

  kdDebug() << "X:Y is " << m_X[i-1] << ":" << m_Y[i-1] << endl;

  // last page?
  if ( i == pageCount() - 1 )
    setFinishEnabled( currentPage(), TRUE );
  else
    setNextEnabled( currentPage(), TRUE );
}

void AdjBorderWizard::accept()
{
  // a small offset to extend the detected size a little bit
  const int offset = 10;

  QRect edges = QRect( QPoint( m_X[ 0 ] - offset, m_Y[ 2 ] - offset ),
               QPoint( m_X[ 1 ] + offset, m_Y[ 3 ] + offset ) );
  SynConfig::setEdges( edges );
  kdDebug() << "updated changed borders!" << edges << endl;
  emit changed();

  restoreState();
  done( QDialog::Accepted );
}

void AdjBorderWizard::reject()
{
  kdDebug() << "reject changed borders!" << endl;
  restoreState();
  done( QDialog::Rejected );
}

void AdjBorderWizard::saveState()
{
  kdDebug() << "save pad states" << endl;
  m_edgeMotion    = TouchPad::isEdgeMotionEnabled();
  m_vertDelta     = TouchPad::verticalScrollDelta();
  m_horizDelta    = TouchPad::horizontalScrollDelta();
  m_circScrolling = TouchPad::isCircularScrollEnabled();
}

void AdjBorderWizard::restoreState()
{
  kdDebug() << "restore pad states" << endl;
  TouchPad::setEdgeMotionEnabled( m_edgeMotion );
  TouchPad::setVerticalScrollDelta( m_vertDelta );
  TouchPad::setHorizontalScrollDelta( m_horizDelta );
  TouchPad::setCircularScrollEnabled( m_circScrolling );
}

void AdjBorderWizard::disableState()
{
  kdDebug() << "disable pad states" << endl;
  TouchPad::setEdgeMotionEnabled( FALSE );
  TouchPad::setVerticalScrollDelta( 0 );
  TouchPad::setHorizontalScrollDelta( 0 );
  TouchPad::setCircularScrollEnabled( FALSE );
  setWFlags( Qt::WType_TopLevel | Qt::WMouseNoMask | Qt::WStyle_StaysOnTop);
}

#include "adjborderwizard.moc"
