/*
 *  KSeg
 *  Copyright (C) 1999-2003 Ilya Baran
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 ibaran@mit.edu
 */


#include "G_undoStack.H"
#include "KSegDocument.H"

void G_undoStack::DoIt()
{
  bool topSortAfter = false;

  do {
    if(isEmpty()) break;

    current()->execute();
    if(current()->isReconstrainUndo()) topSortAfter = true;
    pop(); //deletes it too.

    if(isEmpty()) break;

  } while(!current()->isLastOne());

  if(topSortAfter) doc->topSortAllRefs();
}
