/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include "../ballistics.h"
#include "../gfx.h"

void wgxDrawBlackHoleShot(struct Projectilepos_bal *prjpos, void* info)
{
    int tx=prjpos->x;
    int ty=prjpos->y;
    int otx=prjpos->rox;
    int oty=prjpos->roy;
    int sa=(5*gfx_xsize)/ter_sizex;
    int sb=(5*gfx_ysize)/ter_sizey;
    ggi_color c;
    
    int sx=gfxTerrainToScreenXCoord(tx);
    int sy=gfxTerrainToScreenYCoord(ty);

    gfxDrawArea(otx-gfxScaleScreenToTerrainXDimen(4),
		oty-gfxScaleScreenToTerrainYDimen(4), 
		gfxScaleScreenToTerrainXDimen(6), 
		gfxScaleScreenToTerrainYDimen(6));
    
    if(tx==-1 && ty==-1) return;
    
    c.r=0x6FFF;
    c.g=0x6FFF;
    c.b=0x6FFF;
    c.a=0xFF<<8;
    ggiSetGCForeground(gfx_vis, ggiMapColor(gfx_vis, &c));
    gfxDrawThickEllipse(sx, sy, sa, sb);
    
    /* we might need to redraw walls */
    gfxDrawWalls(otx-gfxScaleScreenToTerrainXDimen(2),
		 oty-gfxScaleScreenToTerrainYDimen(2), 
		 gfxScaleScreenToTerrainXDimen(5), 
		 gfxScaleScreenToTerrainYDimen(5));
}

void wgxDrawBlackHoleExplosion(void* info)
{
    ggi_color c;
    ggi_pixel gfx_hole;
    int tx=((struct DurationExplosion_wep*)info)->x;
    int ty=((struct DurationExplosion_wep*)info)->y;
    int twidth=((struct DurationExplosion_wep*)info)->width;
    int sx=gfxTerrainToScreenXCoord(tx);
    int sy=gfxTerrainToScreenYCoord(ty);
    int sa=(twidth*gfx_xsize)/ter_sizex;
    int sb=(twidth*gfx_ysize)/ter_sizey;
    
    if(((struct DurationExplosion_wep*)info)->duration%2)
    {
	c.g=0x6FFF;
	c.r=0x6FFF;
	c.b=0x6FFF;
    }
    else
    {
        c.g=0x4FFF;
	c.r=0x4FFF;
	c.b=0x4FFF;
    }
    c.a=0xFF<<8;
    
    gfx_hole=ggiMapColor(gfx_vis, &c);
    ggiSetGCForeground(gfx_vis, gfx_hole);
    gfxDrawThickEllipse(sx, sy, sa, sb);
    
    
    if(((struct DurationExplosion_wep*)info)->duration <= 0)
    {
	gfxDrawArea(tx - twidth*2, 
		    ty - twidth*2, 
		    twidth*4, 
		    twidth*4);
    }
}
