/***************************************************************************
                          kmessbuffer.h -  description
                             -------------------
    begin                : Sat July 2 2005
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2005 by Diederik van der Boor
    email                : mkb137b@hotmail.com
                           vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSBUFFER_H
#define KMESSBUFFER_H

#include <qcstring.h>


/**
 * A buffer where received data can be stored and analysed.
 *
 * @author Mike K. Bennett (original work), Diederik van der Boor (made separate class)
 */
class KMessBuffer : public QByteArray
{
  public:
    // Constructor
                           KMessBuffer( unsigned size = 0 );
    // Destructor
    virtual               ~KMessBuffer();
    // Add data
    void                   add( char *str, unsigned size );
    // Retrieve data
    QByteArray             left( unsigned int size ) const;
    // Remove read data
    void                   remove( unsigned size );
    // Find a newline character
    int                    findNewline() const;
    // Return the length of the buffer
    int                    length() const;
};

#endif
