/***************************************************************************
                          addcontactdialog.cpp  -  description
                             -------------------
    begin                : Sun Apr 14 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "addcontactdialog.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qsize.h>

#include <kdebug.h>
#include <klineedit.h>
#include <klocale.h>
#include <kmessagebox.h>

AddContactDialog::AddContactDialog(QWidget *parent, const char *name )
  : KDialogBase( parent, name, false, i18n("Add a contact"), Ok | Cancel, Ok, true )
{
  setInitialSize( configDialogSize("AddContactDialog") );

  QWidget *page = new QWidget( this );
  setMainWidget( page );

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  QLabel *infoLabel = new QLabel( i18n("Enter the email address of the person you wish to add:"), page, "info" );
  topLayout->addWidget( infoLabel );

  handleEdit_ = new KLineEdit( page, "handleedit" );
  handleEdit_->setMinimumWidth( fontMetrics().maxWidth()*20 );
  topLayout->addWidget( handleEdit_ );

  topLayout->addStretch( 10 );

  adjustSize();
}



AddContactDialog::~AddContactDialog()
{
}



// Show the dialog and obtain the contact handle.
bool AddContactDialog::launch(QString &contactHandle)
{
  // Reset the contact handle edit
  handleEdit_->setText("");
  // Reset the "ok"
  ok_ = false;
  // Show the dialog modally
  exec();
  // If the ok button was pressed..
  if ( ok_ )
  {
    QString emailAddress = handleEdit_->text();
    if ( ! emailAddress.isEmpty() )
    {
      // The MSN Servers send a "dot net" message if you try to add a contact like "me@hotmail.co".
      // This "dot net" message caused KMess to disconnect..! Fortunately, this basic test should be
      // more then enough, because stuff like test@test.test passes through the server-side tests.
      bool tooShort = (emailAddress.length() < 6); // shortest: a@b.cd
      bool hasAt    = (emailAddress.find('@') != -1);
      bool hasDot   = (emailAddress.find('.') != -1 && (int) emailAddress.findRev('.') < ((int)emailAddress.length() - 2));
      bool hasCo    = (emailAddress.endsWith(".co")); // strange, 2 random chars for country code are accepted, but .co isn't.
      if(hasAt && hasDot && ! tooShort && ! hasCo)
      {
        // Get the contact handle from the edit.
        contactHandle = handleEdit_->text();
      }
      else
      {
        KMessageBox::error(0, i18n("The e-mail address given was invalid!"));
        ok_ = false;
      }
    }
  }
  return ok_;
}



// The Cancel button was pressed.
void AddContactDialog::slotCancel()
{
  saveDialogSize("AddContactDialog");
  reject();
}



// The OK button was pressed.
void AddContactDialog::slotOk()
{
  saveDialogSize("AddContactDialog");
  ok_ = true;
  accept();
}

#include "addcontactdialog.moc"
