//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kdebluetooth@schaettgen.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef RFCOMMSERVERSOCKET_H
#define RFCOMMSERVERSOCKET_H

#include <qobject.h>
#include <qsocket.h>
#include <qserversocket.h>

class QSocketNotifier;

namespace KBluetooth
{

/** Wrapper for a listening Rfcomm-socket.
 * RfcommServerSocket opens a listening rfcomm socket on a given
 * rfcomm channel and emits a signal when there is a new incoming
 * connection. The file descriptor may be used by the receiver
 * of the signal to initialize a QSocket with it
 * (using QSocket::setSocket()).
 */
class RfcommServerSocket : public QObject
{
    Q_OBJECT
public:
    /** Constructor.
    @param port Rfcomm channel to listen to.
    @param parent owner object
    @param name object name
    */
    RfcommServerSocket(int port, QObject *parent = 0, char *name = 0);

    /** Destructor */
    virtual ~RfcommServerSocket();

signals:
    /** Emitted when there is a new incoming connection.
    @param fd file descriptor for the already accepted socket.
    @param srcaddr source addres of the connection
    @todo srcaddr should be of type KBluetooth::DeviceAddress
    */
    void onNewConnection(int fd, QString srcaddr);

private:
    QSocketNotifier *notifier;
private slots:
    void acceptConnection(int s);
};

}

#endif
