/*****************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi <merzi@it.it>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *****************************************************************************/

#include "DeviceClassDialog.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "DeviceClassDialog.moc"
#include "DeviceClassDialogHandlers.cpp"
#include "BluezConnector.h"

/* 
 *  Constructs a DeviceClassDialog as a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 */
DeviceClassDialog::DeviceClassDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "dialog_class" );

    pushbutton_ok = new QPushButton( this, "pushbutton_ok" );
    pushbutton_ok->setGeometry( QRect( 390, 230, 100, 25 ) );

    buttongroup_device_class = new QButtonGroup( this, "buttongroup_device_class" );
    buttongroup_device_class->setGeometry( QRect( 170, 10, 320, 200 ) );

    listbox_minor = new QListBox( buttongroup_device_class, "listbox_minor" );
    listbox_minor->setGeometry( QRect( 160, 20, 151, 170 ) );

    listbox_major = new QListBox( buttongroup_device_class, "listbox_major" );
    listbox_major->setGeometry( QRect( 10, 20, 140, 170 ) );

    buttongroup_service_classes = new QButtonGroup( this, "buttongroup_service_classes" );
    buttongroup_service_classes->setGeometry( QRect( 10, 10, 150, 200 ) );

    listbox_services = new QListBox( buttongroup_service_classes, "listbox_services" );
    listbox_services->setGeometry( QRect( 10, 20, 130, 170 ) );
    listbox_services->setSelectionMode( QListBox::Multi );

    pushbutton_cancel = new QPushButton( this, "pushbutton_cancel" );
    pushbutton_cancel->setGeometry( QRect( 280, 230, 100, 25 ) );

    lineedit_hex = new QLineEdit( this, "lineedit_hex" );
    lineedit_hex->setGeometry( QRect( 100, 231, 104, 20 ) );

    label_hex = new QLabel( this, "label_hex" );
    label_hex->setGeometry( QRect( 20, 232, 80, 20 ) );
    languageChange();
    setFixedSize( QSize(502, 267).expandedTo(minimumSizeHint()) );

    this->setDeviceClassValues();

    connect( pushbutton_ok, SIGNAL( clicked() ),
             this, SLOT( accept() ) );
    connect( pushbutton_cancel, SIGNAL( clicked() ),
             this, SLOT( reject() ) );
    connect( listbox_major, SIGNAL( selectionChanged() ),
             this, SLOT( listbox_major_selected() ) );
    connect( listbox_minor, SIGNAL( selectionChanged(QListBoxItem*) ),
             this, SLOT( listbox_minor_selected( QListBoxItem*) ) );
    connect( listbox_services, SIGNAL( selectionChanged() ),
             this, SLOT( listbox_services_selected() ) );

    setDeviceClassValues();
}

void DeviceClassDialog::setDeviceClassValues() {
  uint8_t service;
  uint8_t major;
  uint8_t minor;
  const uint8_t* minors;
  unsigned int i;
  int mvcount=0;
  BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
  BluezConnector::KBTDevice* dev = bluezConnector->getCurrentDevice();

  dev->getClass(&service,&major,&minor);
  for (i=0;i<listbox_services->count();i++) {
    listbox_services->setSelected(i,((service&(1<<i))!=0));
  }
  listbox_major->setSelected(major,true);
  listbox_major_selected();

  minors = DeviceClass::get_minor_vals(major,&mvcount);
  for (int j=0;j<mvcount;j++) {
    if (minors[j]==minor)
      listbox_minor->setSelected(j,true);
  }

  service_val=service;
  minor_val=minor;
  major_val=major;
}

/*
 *  Destroys the object and frees any allocated resources
 */
DeviceClassDialog::~DeviceClassDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void DeviceClassDialog::languageChange()
{
    setCaption( tr( "Service/Device Class" ) );
    pushbutton_ok->setText( tr( "Ok" ) );
    buttongroup_device_class->setTitle( tr( "Device Class" ) );
    listbox_major->clear();
    listbox_major->insertItem( tr( "Miscellaneous" ) );
    listbox_major->insertItem( tr( "Computer" ) );
    listbox_major->insertItem( tr( "Phone" ) );
    listbox_major->insertItem( tr( "LAN Access" ) );
    listbox_major->insertItem( tr( "Audio/Video" ) );
    listbox_major->insertItem( tr( "Peripheral" ) );
    listbox_major->insertItem( tr( "Imaging" ) );
    listbox_major->insertItem( tr( "Uncategorized" ) );
    buttongroup_service_classes->setTitle( tr( "Service Classes" ) );
    listbox_services->clear();
    listbox_services->insertItem( tr( "Positioning" ) );
    listbox_services->insertItem( tr( "Networking" ) );
    listbox_services->insertItem( tr( "Rendering" ) );
    listbox_services->insertItem( tr( "Capturing" ) );
    listbox_services->insertItem( tr( "Object Transfer" ) );
    listbox_services->insertItem( tr( "Audio" ) );
    listbox_services->insertItem( tr( "Telephony" ) );
    listbox_services->insertItem( tr( "Information" ) );
    pushbutton_cancel->setText( tr( "Cancel" ) );
    label_hex->setText( tr( "Hex Value:" ) );
}

