//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PINSERVER_H
#define PINSERVER_H

#include <qobject.h>
#include <dcopobject.h>
#include <qcstring.h>

namespace KBluetooth {
    class HciSocket;
}

/**
@author Fred Schaettgen
*/
class PinServer : public QObject, virtual public DCOPObject
{
    Q_OBJECT
    K_DCOP
k_dcop:
    QString pinDialog(bool incoming, QString addr, QString name);

public:
    PinServer(QObject *parent);
    ~PinServer();
private:
    bool ownAuthenticationFlag;
    KBluetooth::HciSocket *hciSocket;
    
private slots:
    void resetOwnAuthtenticationFlag();
    void slotHciEvent(unsigned char, QByteArray);
};

#endif
